package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 表示可以动态添加到不同模块或实体中的自定义字段。
 * @date : 2024-03-18 16:18
 */
@Entity
@Table(name = TableNameConstant.DYNAMIC_BO_FIELD_DEFINITION,
        indexes = {
                @Index(name = "idx_dynamic_bofield_businessobj", columnList = "businessObjectCode"),
                @Index(name = "idx_dynamic_bofield_bmocode", columnList = "basicModuleCode"),
        })
@Comment("数据模型的字段")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class DynamicBoFieldDefinitionDO extends BaseModel {
    private static final long serialVersionUID = -2316168965315122111L;

    @Column(nullable = false)
    @Comment("数据模型编码")
    private String basicModuleCode;

    @Column()
    @Comment("业务对象编码")
    private String businessObjectCode;

    @Column(nullable = false)
    @Comment(value = "是否数据库字段", defaultValue = "0")
    private Boolean dbField;

    @Column()
    @Comment("字段长度")
    private Integer dbFieldLength;

    @Column()
    @Comment("字段精度")
    private Integer dbFieldPrecision;

    @Column()
    @Comment("小数位数")
    private Integer dbFieldScale;

    @Column()
    @Comment(value = "字段是否可为空", defaultValue = "1")
    private Boolean dbFieldNullable;

    @Column()
    @Comment(value = "是否唯一", defaultValue = "0")
    private Boolean dbFieldUnique;

    @Column()
    @Comment(value = "是否创建索引", defaultValue = "0")
    private Boolean dbFieldIndex;

    @Column(nullable = false)
    @Comment("字段标识")
    private String basicKey;

    @Comment("字段标识的别名")
    private String basicKeyAs;

    @Column()
    @Comment("显示名称")
    private String basicName;

    @Column(nullable = false)
    @Comment("数据类型")
    @Enumerated(EnumType.STRING)
    private BoModelFieldTypeEnum basicType;

    @Column()
    @Comment("字段描述")
    private String basicDescription;

    @Column()
    @Comment("默认值")
    private String basicDefaultValue;

    @Column()
    @Comment(value = "前端显示的顺序", defaultValue = "0")
    private Integer basicDisplayOrder;

    @Column()
    @Comment(value = "字段是否启用", defaultValue = "1")
    private Boolean basicState;

    @Column()
    @Comment("在前端UI中的展示方式")
    private String displayType;

    @Comment("选项值，仅对枚举类型的字段适用，存储为JSON字符串")
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> displayOptionsJson;

    @Column()
    @Comment(value = "是否可以包含多个值", defaultValue = "0")
    private Boolean displayMultivalue;

    @Column()
    @Comment("字段分组名称，用于在UI中将相关字段组织在一起展示")
    private String displayGroup;

    @Column()
    @Comment(value = "在前端是否只读", defaultValue = "0")
    private Boolean displayReadonly;

    @Comment("控制字段在UI中的可见性的条件，存储为JSON字符串")
    @Convert(converter = JsonStringMapConverter.class)
    @Lob
    private Map<String, Object> displayVisibilityConditionJson;

    @Comment("UI组件属性，提供额外的配置以支持更复杂的前端UI控件")
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> displayUiAttributesJson;

    @Comment("动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值")
    @Convert(converter = JsonStringMapConverter.class)
    @Lob
    private Map<String, Object> displayDynamicAttributesJson;

    @Comment("依赖字段，当前字段的展示或值可能依赖于其他字段的状态或值")
    @Convert(converter = JsonStringMapConverter.class)
    @Lob
    private Map<String, Object> displayDependentFieldsJson;

    @Column()
    @Comment("前端验证模式，提供一个正则表达式或其他验证模式，用于前端实时验证用户输入。")
    @Lob
    private String configWebValidationPattern;

    @Column()
    @Comment("前端扩展数据存储")
    @Lob
    private String configWebExtendedData;

    @Column()
    @Comment("前端函数存储")
    @Lob
    private String configWebFunction;

    @Column()
    @Comment(value = "是否可以用作搜索条件", defaultValue = "0")
    private Boolean configSearchable;

    @Column()
    @Comment(value = "是否可以用作列表排序", defaultValue = "0")
    private Boolean configSortable;

    @Column()
    @Comment(value = "是否应包含在数据导入导出中", defaultValue = "0")
    private Boolean configImportExport;

    @Column()
    @Comment("权限控制，存储为JSON字符串。定义了哪些用户或角色可以访问或修改字段")
    @Lob
    private String configAccessControlJson;

    @Column()
    @Comment(value = "是否追踪字段值的变更历史", defaultValue = "0")
    private Boolean configTrackHistory;

    @Column()
    @Comment(value = "是否加密", defaultValue = "0")
    private Boolean configEncrypted;

    @Column()
    @Comment(value = "是否大小写敏感", defaultValue = "0")
    private Boolean configSensitive;

    @Column()
    @Comment("自动填充建议属性，存储为JSON字符串。提供用户输入时的自动完成建议。")
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> configAutocompleteSuggestionsJson;
}