
package com.elitescloud.cloudt.lowcode.dynamic.model.param;

import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 表示可以动态添加到不同模块或实体中的自定义字段。
 * @date : 2024-03-18 16:18
 */

@Data
@ApiModel(value = "CustomFieldDefinitionSaveParam", description = "CustomFieldDefinitionSaveParam")
public class BoFieldDefinitionSaveParam implements Serializable {

    // 基础属性
    @ApiModelProperty("标识此字段所属的业务对象编码")
    private String businessObjectCode; // 标识此字段所属的业务对象。

    @ApiModelProperty("标识此字段所属的模块或实体")
    private String basicModuleCode; // 标识此字段所属的模块或实体。

    @ApiModelProperty("是否数据库字段")
    @NotNull
    private Boolean dbField;
    
    @ApiModelProperty("数据库表名")
    @NotBlank
    private String dbTableName; //表名
    /**
     * 数据库和API中使用的唯一键名。
     * 它用于程序内部识别不同的字段，因此必须是唯一的。
     */
    @ApiModelProperty("数据库和API中使用的唯一键名")
    @NotBlank
    private String basicKey;

    @ApiModelProperty("数据库和API中使用的唯一键名别名")
    private String basicKeyAs;
    /**
     * 用户界面显示的字段名。
     * 例如，如果是一个客户管理系统，可能有"客户姓名"、"联系电话"等字段名称。
     */
    @ApiModelProperty("用户界面显示的字段名")
    @NotBlank
    private String basicName;

//    /**
//     * 支持多语言环境下的字段名称。
//     * 用于在不同的语言环境下提供相应的字段名称，增强国际化支持。
//     */
//    @ApiModelProperty("支持多语言环境下的字段名称")
//    private String basicLocalizedName;


    /**
     * 字段的数据类型。
     * 表明字段存储的数据是什么类型，如字符串(string)、数字(number)、布尔值(boolean)等。
     */
    @ApiModelProperty("字段的数据类型")
    @NotNull
    private BoModelFieldTypeEnum basicType;

    @ApiModelProperty("数据库字段元数据对象")
    private DbFieldBaseModel dbFieldBaseModel;
    /**
     * 字段用途或输入要求的描述信息。
     * 对字段进行简单的说明，帮助理解字段的用途或填写要求。
     */
    @ApiModelProperty("字段用途或输入要求的描述信息。")
    private String basicDescription;

//    /**
//     * 指向字段说明或帮助文档的URL。
//     * 可以链接到外部文档，提供更详细的字段说明或填写指南。
//     */
//    @Column()
//    @ApiModelProperty("指向字段说明或帮助文档的URL")
//    private String basicHelpUrl;

    /**
     * 创建实体时的默认值。
     * 如果字段在创建时未指定值，将使用此默认值。
     */
    @ApiModelProperty("创建实体时的默认值")
    private String basicDefaultValue;

    /**
     * 指示字段在创建或更新实体时是否必填。
     * true表示必填，false表示非必填。
     */
    @ApiModelProperty("指示字段在创建或更新实体时是否必填")
    private Boolean basicRequired;


    /**
     * 前端显示的排序顺序。
     * 用于调整字段在界面上的展示顺序，数字越小越靠前。
     */
    @ApiModelProperty("前端显示的排序顺序")
    private Integer basicDisplayOrder;

    /**
     * 字段是否启用。
     * "active"表示启用，"inactive"表示禁用。
     */
    @ApiModelProperty("字段是否启用")
    private String basicStatus;

// 展示和交互属性

    /**
     * 展示类型指明了字段在前端UI中的展示方式，如文本框(textbox)、下拉列表(dropdown)、单选按钮(radiobutton)等。
     * 这有助于前端应用根据不同的类型渲染适当的输入控件。
     */
    @ApiModelProperty("展示类型指明了字段在前端UI中的展示方式")
    private String displayType;

    /**
     * 选项值，仅对枚举类型的字段适用，存储为JSON字符串。
     * 例如，如果字段表示状态，选项值可能包含"激活"和"禁用"。
     */
    @ApiModelProperty("选项值，仅对枚举类型的字段适用，存储为JSON字符串")
    private Map<String, Object> displayOptionsJson;

    /**
     * 指示字段是否可以包含多个值。对于如标签这样的字段特别有用，用户可以输入多个值。
     */
    @ApiModelProperty("指示字段是否可以包含多个值")
    private Boolean displayMultivalue;

    /**
     * 字段分组名称，用于在UI中将相关字段组织在一起展示，以提高表单的可用性和逻辑性。
     */
    @ApiModelProperty("字段分组名称，用于在UI中将相关字段组织在一起展示，以提高表单的可用性和逻辑性")
    private String displayGroup;

    /**
     * 只读属性指示字段在UI中是否只能被显示而不能被修改。
     * 这常用于某些自动生成的字段，如创建时间戳。
     */
    @ApiModelProperty("只读属性指示字段在UI中是否只能被显示而不能被修改")
    private Boolean displayReadonly;

    /**
     * 控制字段在UI中的可见性的条件，存储为JSON字符串。
     * 可以基于其他字段的值动态显示或隐藏该字段。
     */
    @ApiModelProperty("控制字段在UI中的可见性的条件，存储为JSON字符串")
    private Map<String, Object> displayVisibilityConditionJson;

    /**
     * UI组件属性，提供额外的配置以支持更复杂的前端UI控件，如指定日期选择器的格式，存储为JSON字符串。
     */
    @ApiModelProperty(" UI组件属性，提供额外的配置以支持更复杂的前端UI控件，如指定日期选择器的格式，存储为JSON字符串")
    private Map<String, Object> displayUiAttributesJson;

    /**
     * 关联实体类型和关系。如果字段值指向另一个实体，该属性定义了所关联的实体类型。
     * 例如，一个订单实体可能有一个指向客户实体的字段。
     */
    @Column()
    private String displayLinkedEntity;

    /**
     * 动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值，存储为JSON字符串。
     */
    @ApiModelProperty("动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值，存储为JSON字符串")
    private Map<String, Object> displayDynamicAttributesJson;


    /**
     * 依赖字段，存储为JSON字符串。当前字段的展示或值可能依赖于其他字段的状态或值。
     * 例如，某些字段只在特定条件下可用。
     */
    @ApiModelProperty("依赖字段，存储为JSON字符串。当前字段的展示或值可能依赖于其他字段的状态或值。")
    private Map<String, Object> displayDependentFieldsJson;

// 高级配置属性
//    /**
//     * 字段值的验证规则，可用正则表达式或其他规则。
//     * 用于确保输入的数据满足特定格式或条件。
//     */
//    @Column()
//    @ApiModelProperty("后端字段值的验证规则")
//    @Lob
//    private String basicValidationRule;
//    /**
//     * 验证失败时的自定义消息。
//     * 提供一个更友好的提示信息，告知用户为何验证未通过。
//     */
//    @Column()
//    @ApiModelProperty("后端验证失败时的自定义消息")
//    private String basicValidationMessage;
    /**
     * 前端验证模式，提供一个正则表达式或其他验证模式，用于前端实时验证用户输入。
     * 这有助于提前捕捉错误并改善用户体验。
     */
    @ApiModelProperty("前端校验模式数据存储")
    private String configWebValidationPattern;

    @ApiModelProperty("前端扩展数据存储")
    private String configWebExtendedData;

    @ApiModelProperty("前端函数存储")
    private String configWebFunction;
//    @Column()
//    @ApiModelProperty("前端正则验证规则消息")
//    private String configValidationPatternMessage;
    /**
     * 可搜索属性标记字段是否可以被用作搜索条件。
     * 这对于实现动态搜索和过滤功能特别重要。
     */
    @ApiModelProperty("可搜索属性标记字段是否可以被用作搜索条件")
    private Boolean configSearchable;

    /**
     * 可排序属性指示字段是否可以用作列表排序的依据。
     */
    @ApiModelProperty("可排序属性指示字段是否可以用作列表排序的依据")
    private Boolean configSortable;

    /**
     * 导入导出属性标记字段是否应包含在数据导入导出操作中。
     * 这有助于控制哪些字段是数据交换的一部分。
     */
    @ApiModelProperty("导入导出属性标记字段是否应包含在数据导入导出操作中")
    private Boolean configImportExport;

    /**
     * 权限控制，存储为JSON字符串。定义了哪些用户或角oles可以访问或修改字段。
     * 这对于实现细粒度的访问控制非常有用。
     */
    @ApiModelProperty("权限控制，存储为JSON字符串")
    private String configAccessControlJson;

    /**
     * 历史记录属性指示是否追踪字段值的变更历史。
     * 这对于审计和记录数据变更非常重要。
     */
    @ApiModelProperty("历史记录属性指示是否追踪字段值的变更历史")
    private Boolean configTrackHistory = false;

    /**
     * 数据加密属性标记字段存储的数据是否需要加密，用于敏感信息。
     * 这确保敏感数据如个人身份信息（PII）在数据库中的安全。
     */
    @ApiModelProperty("数据加密属性标记")
    private Boolean configEncrypted = false;
    /**
     * 敏感数据标记属性指示字段是否包含敏感数据。
     * 该标记用于确保在处理、显示或导出数据时采取额外的预防措施。
     */
    @ApiModelProperty("敏感数据标记")
    private Boolean configSensitive = false;

    /**
     * 自动填充建议属性，存储为JSON字符串。提供用户输入时的自动完成建议。
     * 适用于那些有限且可预测输入值的字段，如用户名或地点名称。
     */
    @ApiModelProperty("自动填充建议属性")
    private Map<String, Object> configAutocompleteSuggestionsJson;


}