package com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 功能模块分页查询结果.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Getter
@Setter
@ApiModel(description = "功能模块分页查询结果")
public class DynamicConfiguratorPageRespVO implements Serializable {
    private static final long serialVersionUID = 5526618539339501235L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty("功能模块编码")
    private String dynamicConfiguratorCode;

    @ApiModelProperty("功能模块名称")
    private String dynamicConfiguratorName;

    @ApiModelProperty("描述")
    private String dynamicConfiguratorDescription;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    /**
     * 审批类型 UDC[cloudt-system:approveType]
     * <p>
     * {@link com.elitescloud.cloudt.lowcode.dynamic.common.ApproveTypeUdc}
     */
    @ApiModelProperty("流程审批类型")
    private String approvalType;
    private String approvalTypeName;

    @ApiModelProperty(value = "是否已发布")
    private Boolean published;

    @ApiModelProperty("发布应用编码")
    private String appCode;
    private String appName;

    @ApiModelProperty("发布后菜单编码")
    private String menuCode;
    private String menuName;

    @ApiModelProperty(value = "发布后的菜单")
    private List<IdCodeNameParam> menus;

    @ApiModelProperty(value = "是否已部署")
    private Boolean deployed;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "修改人")
    private String updater;
}
