package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 15:10
 */
@Repository
public interface DbFieldRepository extends JpaRepository<DbFieldDo, Long>, QuerydslPredicateExecutor<DbFieldDo> {
    @Transactional
    @Modifying
    @Query("delete from DbFieldDo d where d.dbTableName = ?1 and d.tableSchema = ?2")
    int deleteByDbTableNameAndTableSchema(String dbTableName, String tableSchema);
    // 可以添加自定义查询方法
}