package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelColumnBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.*;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/23
 */
@Repository
public class DynamicBoFieldDefinitionRepoProc extends BaseRepoProc<DynamicBoFieldDefinitionDO> {
    private static final QDynamicBoFieldDefinitionDO QDO = QDynamicBoFieldDefinitionDO.dynamicBoFieldDefinitionDO;
    private static final QDynamicBoModelDO QDO_MODEL = QDynamicBoModelDO.dynamicBoModelDO;
    private static final QDynamicConfiguratorDO QDO_CFG = QDynamicConfiguratorDO.dynamicConfiguratorDO;
    private static final QDynamicConfiguratorBoModelRelationDO QDO_MODEL_RELATION = QDynamicConfiguratorBoModelRelationDO.dynamicConfiguratorBoModelRelationDO;


    public DynamicBoFieldDefinitionRepoProc() {
        super(QDO);
    }

    /**
     * 根据模型删除
     */
    public void deleteByBoModelId(long boModelId) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.basicModuleCode.eq(
                        JPAExpressions.select(QDO_MODEL.boModelCode).from(QDO_MODEL).where(QDO_MODEL.id.eq(boModelId))
                )).execute();
    }

    /**
     * 获取字段列表
     *
     * @param boModelCode
     * @return
     */
    public List<String> getBasicKeys(@NotBlank String boModelCode) {
        return super.getValueListByValue(QDO.basicKey, QDO.basicModuleCode, boModelCode);
    }

    /**
     * 获取ID列表
     *
     * @param boModelCode
     * @return
     */
    public List<Long> getIdsByBoModelCode(@NotBlank String boModelCode) {
        return super.getValueListByValue(QDO.id, QDO.basicModuleCode, boModelCode);
    }

    /**
     * 根据模型获取
     *
     * @param boModelId
     * @return
     */
    public List<DynamicBoFieldDefinitionDO> listByBoModelId(long boModelId) {
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.basicModuleCode.eq(
                        JPAExpressions.select(QDO_MODEL.boModelCode).from(QDO_MODEL).where(QDO_MODEL.id.eq(boModelId))
                ))
                .fetch();
    }

    /**
     * 获取当前最大序号
     *
     * @param boModelCode
     * @return
     */
    public Integer getMaxSortNo(@NotBlank String boModelCode) {
        return super.jpaQueryFactory.select(QDO.basicDisplayOrder.max())
                .from(QDO)
                .where(QDO.basicModuleCode.eq(boModelCode))
                .fetchOne();
    }

    /**
     * 根据功能模块获取字段列表
     *
     * @param configuratorId
     * @return
     */
    public List<DynamicBoFieldDefinitionDO> listByConfiguratorId(long configuratorId) {
        var predicate = QDO.basicModuleCode.in(
                JPAExpressions.select(QDO_MODEL_RELATION.boModelCode).from(QDO_MODEL_RELATION).where(QDO_MODEL_RELATION.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(configuratorId))
                ))
        );
        return super.getList(predicate);
    }

    /**
     * 根据表获取字段
     *
     * @param boModelCodes
     * @return
     */
    public List<DynamicModelColumnBO> listColumnBO(@NotEmpty Collection<String> boModelCodes) {
        var predicate = QDO.basicModuleCode.in(boModelCodes).and(QDO.dbField.eq(true).and(QDO.basicState.eq(true)));
        return super.getList(qBeanColumnBO(), predicate);
    }

    private QBean<DynamicModelColumnBO> qBeanColumnBO() {
        return Projections.bean(DynamicModelColumnBO.class, QDO.basicModuleCode, QDO.basicKey, QDO.basicName, QDO.basicDescription, QDO.basicType,
                QDO.basicDefaultValue, QDO.dbFieldLength, QDO.dbFieldPrecision, QDO.dbFieldScale, QDO.dbFieldNullable, QDO.dbFieldUnique,
                QDO.dbFieldIndex, QDO.basicDisplayOrder);
    }
}
