package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.common.ModelRelationTypeUdc;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelTableBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorBoModelRelationDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorBoModelRelationDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoModelDetailListRespVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorBoModelListRespVO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Repository
public class DynamicConfigurationBoModelRelationRepoProc extends BaseRepoProc<DynamicConfiguratorBoModelRelationDO> {
    private static final QDynamicConfiguratorBoModelRelationDO QDO = QDynamicConfiguratorBoModelRelationDO.dynamicConfiguratorBoModelRelationDO;
    private static final QDynamicBoModelDO QDO_MODEL = QDynamicBoModelDO.dynamicBoModelDO;
    private static final QDynamicConfiguratorDO QDO_CFG = QDynamicConfiguratorDO.dynamicConfiguratorDO;

    public DynamicConfigurationBoModelRelationRepoProc() {
        super(QDO);
    }

    /**
     * 删除模型关系
     *
     * @param dynamicConfiguratorId
     * @param boModelCode
     */
    public void deleteRelation(long dynamicConfiguratorId, String boModelCode) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(dynamicConfiguratorId))
                ))
                .andEq(QDO.boModelCode, boModelCode)
                .build();
        super.jpaQueryFactory.delete(QDO)
                .where(predicate)
                .execute();
    }

    /**
     * 获取主表编码
     *
     * @param dynamicConfiguratorCode
     * @return
     */
    public List<String> getPrimaryModelCodes(@NotBlank String dynamicConfiguratorCode) {
        return super.jpaQueryFactory.select(QDO.boModelCode)
                .from(QDO)
                .where(QDO.dynamicConfiguratorCode.eq(dynamicConfiguratorCode).and(QDO.boModelType.eq(ModelRelationTypeUdc.PRIMARY.getValue())))
                .fetch();
    }

    /**
     * 获取模型编码
     *
     * @param configuratorId 功能模块ID
     * @return
     */
    public List<String> getModelCodes(long configuratorId) {
        return super.jpaQueryFactory.select(QDO.boModelCode)
                .from(QDO)
                .where(QDO.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(configuratorId))
                ))
                .fetch();
    }

    /**
     * 获取模型关系
     *
     * @param dynamicConfiguratorCode
     * @param boModelCode
     * @return
     */
    public DynamicConfiguratorBoModelRelationDO getBoModelRelation(@NotBlank String dynamicConfiguratorCode, @NotBlank String boModelCode) {
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.dynamicConfiguratorCode.eq(dynamicConfiguratorCode).and(QDO.boModelCode.eq(boModelCode)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取模型关系
     *
     * @param dynamicConfiguratorId
     * @param boModelCode
     * @return
     */
    public DynamicConfiguratorBoModelRelationDO getBoModelRelation(long dynamicConfiguratorId, @NotBlank String boModelCode) {
        return super.jpaQueryFactory.selectFrom(QDO)
                .where(QDO.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(dynamicConfiguratorId))
                ).and(QDO.boModelCode.eq(boModelCode)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取模型关系列表
     *
     * @param dynamicConfiguratorId
     * @return
     */
    public List<DynamicConfiguratorBoModelListRespVO> listBoModelRelation(long dynamicConfiguratorId) {
        return jpaQueryFactory.select(qBeanListRespVO())
                .from(QDO)
                .leftJoin(QDO_MODEL).on(QDO_MODEL.boModelCode.eq(QDO.boModelCode))
                .where(QDO.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(dynamicConfiguratorId))
                )).fetch();
    }

    /**
     * 获取模型关系列表
     *
     * @param dynamicConfiguratorId
     * @return
     */
    public List<DynamicConfiguratorBoModelDetailListRespVO> listBoModelDetail(long dynamicConfiguratorId) {
        return jpaQueryFactory.select(qBeanDetailListRespVO())
                .from(QDO)
                .leftJoin(QDO_MODEL).on(QDO_MODEL.boModelCode.eq(QDO.boModelCode))
                .where(QDO.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(dynamicConfiguratorId))
                )).fetch();
    }

    /**
     * 根据功能模块获取表模型
     *
     * @param configuratorCode
     * @return
     */
    public List<DynamicModelTableBO> listModelTableByConfiguratorCode(@NotBlank String configuratorCode) {
        return jpaQueryFactory.select(qBeanModelTableBO())
                .from(QDO_MODEL)
                .where(QDO_MODEL.boModelCode.in(
                        JPAExpressions.select(QDO.boModelCode).from(QDO).where(QDO.dynamicConfiguratorCode.eq(configuratorCode))
                )).fetch();
    }

    private QBean<DynamicConfiguratorBoModelListRespVO> qBeanListRespVO() {
        return Projections.bean(DynamicConfiguratorBoModelListRespVO.class, QDO_MODEL.id.as("boModelId"),
                QDO_MODEL.boModelCode, QDO_MODEL.boModeName, QDO_MODEL.description, QDO.boModelType);
    }

    private QBean<DynamicConfiguratorBoModelDetailListRespVO> qBeanDetailListRespVO() {
        return Projections.bean(DynamicConfiguratorBoModelDetailListRespVO.class, QDO_MODEL.id.as("boModelId"),
                QDO_MODEL.boModelCode, QDO_MODEL.boModeName, QDO_MODEL.description, QDO.boModelType);
    }

    private QBean<DynamicModelTableBO> qBeanModelTableBO() {
        return Projections.bean(DynamicModelTableBO.class, QDO_MODEL.boModelCode, QDO_MODEL.boModeName, QDO_MODEL.databaseTableName);
    }
}
