package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicDeployRecordDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicDeployRecordDO;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/25
 */
@Repository
public class DynamicDeployRecordRepoProc extends BaseRepoProc<DynamicDeployRecordDO> {
    private static final QDynamicDeployRecordDO QDO = QDynamicDeployRecordDO.dynamicDeployRecordDO;
    private static final QDynamicConfiguratorDO QDO_CFG = QDynamicConfiguratorDO.dynamicConfiguratorDO;

    public DynamicDeployRecordRepoProc() {
        super(QDO);
    }

    /**
     * 根据功能删除
     *
     * @param configuratorId
     */
    public void deleteByDynamicConfigurator(long configuratorId) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.dynamicConfiguratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(configuratorId))
                )).execute();
    }

    /**
     * 更新部署结果
     *
     * @param id
     * @param failReason
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateDeployResult(long id, String failReason) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.success, failReason == null)
                .set(QDO.finished, true)
                .set(QDO.failReason, failReason)
                .set(QDO.finishTime, LocalDateTime.now())
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 获取部署记录
     *
     * @param id
     * @return
     */
    public List<DynamicDeployRecordDO> listByDynamicConfigurator(long id) {
        var predicate = QDO.dynamicConfiguratorCode.eq(
                JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(id))
        );
        return super.getList(predicate);
    }
}
