package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 15:12
 */

import cn.hutool.core.bean.BeanException;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.Table;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.DbModelConvert;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbTableVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DbFieldRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DbTableRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.*;
import com.querydsl.core.types.Predicate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service
public class DbTableServiceImpl implements DbTableService {


    private final DbTableRepository dbTableRepository;
    private final DbFieldService dbFieldService;
    private final DbFieldRelationService dbFieldRelationService;
    private final DbFieldRepository dbFieldRepository;
    private final DbDataSourceMetadataService dbDataSourceMetadataService;

    public DbTableServiceImpl(DbTableRepository dbTableRepository, DbFieldService dbFieldService, DbFieldRelationService dbFieldRelationService
            , DbFieldRepository dbFieldRepository, DbDataSourceMetadataService dbDataSourceMetadataService) {
        this.dbTableRepository = dbTableRepository;
        this.dbFieldService = dbFieldService;
        this.dbFieldRelationService = dbFieldRelationService;
        this.dbFieldRepository = dbFieldRepository;
        this.dbDataSourceMetadataService = dbDataSourceMetadataService;
    }


    @Override
    public DbTableVo findByTableName(String TableName) {
        var QDO = QDbTableDo.dbTableDo;
        Predicate predicate = JpaPredicateBuilder.builder()
                .and(QDO.tableName::eq, TableName)
                .getPredicate();
        DbTableDo dbTable = dbTableRepository.findOne(predicate).orElseThrow(() -> new BeanException(TableName + "不存在"));
        DbTableVo dbTableVo = DbModelConvert.INSTANCE.dbTableDoToVo(dbTable);

        var dbFieldVos = dbFieldService.findByTableName(TableName);
        dbTableVo.setDbFieldVos(dbFieldVos);
        return dbTableVo;
    }

    @Override
    public List<DbTableDo> findAll() {
        return dbTableRepository.findAll();
    }


    @Override
    public DbTableDo findById(Long id) {
        return dbTableRepository.findById(id).orElse(null);
    }

    @Override
    public DbTableDo save(DbTableDo dbTable) {
        return dbTableRepository.save(dbTable);
    }

    @Override
    public void delete(Long id) {
        dbTableRepository.deleteById(id);
    }


    // 收集并存储所有表的元数据


    @Override
    @Transactional
    public ApiResult<String> storeTablesAndFieldsMetadata(DbTableParam dbTableParam) {
        Table table = dbDataSourceMetadataService.getTableMeta(dbTableParam.getCatalog(),
                dbTableParam.getSchema(), dbTableParam.getTableName());

        DbTableDo dbTableDo=new DbTableDo();
        dbTableDo.hutoolTableToDo(table);

        List DbFieldDos=new ArrayList();
        for (Column column : table.getColumns()) {
            DbFieldDo dbFieldDo=new DbFieldDo();
            dbFieldDo.hutoolColumnToDo(column);
            dbFieldDo.setTableSchema(dbTableDo.getTableSchema());
            dbFieldDo.setTableCatalog(dbTableDo.getTableCatalog());
            DbFieldDos.add(dbFieldDo);
        }
        dbTableRepository.deleteByTableNameAndTableSchema(dbTableDo.getTableName(),dbTableDo.getTableSchema());
        dbTableRepository.save(dbTableDo);
        dbFieldRepository.deleteByDbTableNameAndTableSchema(dbTableDo.getTableName(),dbTableDo.getTableSchema());
        dbFieldRepository.saveAll(DbFieldDos);
        return ApiResult.ok();
    }
}
