package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldBatchSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.querydsl.core.types.Predicate;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 业务对象字段定义服务接口
 * @author : chen.niu
 * @description : 提供业务对象字段的创建、查询、更新和删除等操作
 * @date : 2024-04-02 10:17
 */
public interface DynamicBoFieldDefinitionService {
    /**
     * 根据查询参数获取查询条件
     * @param boFieldParam 查询参数
     * @return 返回构建好的查询条件
     */
    static Predicate getPredicateByBoFieldQueryParam(BoFieldQueryParam boFieldParam) {
        var QDO = QDynamicBoFieldDefinitionDO.dynamicBoFieldDefinitionDO;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.basicName::like, StringUtils.hasText(boFieldParam.getBasicName()) ? "%" + boFieldParam.getBasicName() + "%" : null)
                .and(QDO.basicModuleCode::eq, boFieldParam.getBasicModuleCode())
                .and(QDO.basicKey::eq, boFieldParam.getBasicKey())
                .and(QDO.businessObjectCode::eq, boFieldParam.getBusinessObjectCode())
                .and(QDO.dbField::eq, boFieldParam.getDbField())
                .getPredicate();
        return predicate;
    }

    /**
     * 创建业务对象字段
     * @param boFieldParam 创建参数
     * @return 返回创建结果
     */
    ApiResult<Long> createBoField(BoFieldDefinitionSaveParam boFieldParam);
    ApiResult boFieldBatchSave(  BoFieldBatchSaveParam param);

    /**
     * 根据ID获取业务对象字段定义
     * @param id 字段定义ID
     * @return 返回字段定义详情
     */
    DynamicBoFieldDefinitionDO getBoFieldById(Long id);

    /**
     * 更新业务对象字段定义
     * @param id 字段定义ID
     * @param boFieldDetails 更新参数
     * @return 返回更新结果
     */
    ApiResult updateBoField(Long id, BoFieldDefinitionUpdateParam boFieldDetails);

    /**
     * 删除业务对象字段定义
     * @param id 字段定义ID
     */
    void deleteBoField(Long id);

    /**
     * 分页查询业务对象字段定义
     * @param boFieldParam 查询参数
     * @return 返回分页查询结果
     */
    PagingVO<DynamicBoFieldDefinitionDO> searchBoFields(BoFieldQueryParam boFieldParam);

    /**
     * 根据查询参数查询业务对象字段定义列表
     * @param boFieldParam 查询参数
     * @return 返回字段定义列表
     */
    List<DynamicBoFieldDefinitionDO> searchBoFieldList(BoFieldQueryParam boFieldParam);


    List<DynamicBoFieldDefinitionDO> getBoModelByCodeList(String boModelCode);


    void deleteByBoCode(String boModelCode);
}
