package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-18 16:35
 */


import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;


import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbFieldBaseModel;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldBatchSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoFieldDefinitionRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.querydsl.core.types.Predicate;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * BoFieldService接口的实现。
 */
@Service
public class DynamicBoFieldDefinitionServiceImpl
        implements DynamicBoFieldDefinitionService {

    private final BoFieldDefinitionRepository repository;

    private final  BoModelRepository boModelRepository;

    public DynamicBoFieldDefinitionServiceImpl(BoFieldDefinitionRepository repository, BoModelRepository boModelRepository) {
        this.repository = repository;
        this.boModelRepository = boModelRepository;
    }

    @Override
    @Transactional
    public ApiResult<Long> createBoField(BoFieldDefinitionSaveParam boFieldParam) {
        boolean hasUpperCase = boFieldParam.getBasicKey().matches(".*[A-Z].*");
        if(hasUpperCase){
            return ApiResult.fail("字段key不能包含大写字母");
        }
        var boDo=boModelRepository.findByBoModelCode(boFieldParam.getBasicModuleCode()).orElseThrow(() -> new RuntimeException("业务对象不存在"));
        var QDO = QDynamicBoFieldDefinitionDO.dynamicBoFieldDefinitionDO;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.basicKey::eq, boFieldParam.getBasicKey())
                .and(QDO.basicModuleCode::eq, boFieldParam.getBasicModuleCode())
                .and(QDO.businessObjectCode::eq, boFieldParam.getBusinessObjectCode())
                .getPredicate();
        boolean exists = repository.findBy(predicate, fetchableFluentQuery -> {
            return fetchableFluentQuery.exists();
        });
        if (exists) {
            return ApiResult.fail("字段key不能重复");
        }
        DbFieldBaseModel dbFieldBaseModel = boFieldParam.getDbFieldBaseModel();
        DynamicBoFieldDefinitionDO boFieldDefinitionEntity = new DynamicBoFieldDefinitionDO();
        if(dbFieldBaseModel!=null){
            BeanUtils.copyProperties(dbFieldBaseModel, boFieldDefinitionEntity);
        }
        BeanUtils.copyProperties(boFieldParam, boFieldDefinitionEntity);
//        boFieldDefinitionEntity.setDbTableName(boDo.getDatabaseTableName());

        // 将新的自定义字段保存到数据库
        repository.save(boFieldDefinitionEntity);

        return ApiResult.ok(boFieldDefinitionEntity.getId());
    }
    @Override
    @Transactional
    public ApiResult boFieldBatchSave( BoFieldBatchSaveParam param) {
        if(param==null||param.getBasicModuleCode()==null||param.getBoFieldDefinitionSaveParam()==null){
            return ApiResult.fail("参数不能为空");
        }

//        var QDO = QDynamicBoFieldDefinitionDO.dynamicBoFieldDefinitionDO;
//        var predicate = JpaPredicateBuilder.builder()
//                .and(QDO.basicModuleCode::eq,  param.getBasicModuleCode())
//                .getPredicate();
         repository.deleteByBasicModuleCode(param.getBasicModuleCode());

        for (BoFieldDefinitionSaveParam boFieldDefinitionSaveParam : param.getBoFieldDefinitionSaveParam()) {
            createBoField(boFieldDefinitionSaveParam);
        }


        return ApiResult.ok();
    }
    @Override
    public DynamicBoFieldDefinitionDO getBoFieldById(Long id) {
        // 通过ID获取自定义字段
        return repository.findById(id)
                .orElseThrow(() -> new RuntimeException("未找到该ID的自定义字段 :: " + id));
    }


    @Override
    @Transactional
    public ApiResult<Boolean> updateBoField(Long id, BoFieldDefinitionUpdateParam boFieldDetails) {
        // 更新现有的自定义字段
        DynamicBoFieldDefinitionDO boField = repository.findById(id)
                .orElseThrow(() -> new RuntimeException("未找到该ID的自定义字段 :: " + id));
        DbFieldBaseModel dbFieldBaseModel = boFieldDetails.getDbFieldBaseModel();
        if(dbFieldBaseModel!=null){
            BeanUtils.copyProperties(dbFieldBaseModel,boField);
        }
        BeanUtils.copyProperties(boFieldDetails,boField);

        // 在这里更新字段
        repository.save(boField);
        return ApiResult.ok(true);
    }


    @Override
    @Transactional
    public void deleteBoField(Long id) {
        // 通过ID删除自定义字段
        repository.deleteById(id);
    }
    @Override
    public void deleteByBoCode(String boModelCode) {
        repository.deleteByBasicModuleCode(boModelCode);
    }

    @Override
    public PagingVO<DynamicBoFieldDefinitionDO> searchBoFields(BoFieldQueryParam boFieldParam) {
        // 获取所有自定义字段
        Predicate predicate = DynamicBoFieldDefinitionService.getPredicateByBoFieldQueryParam(boFieldParam);
        Page<DynamicBoFieldDefinitionDO> page = repository.findAll(predicate, boFieldParam.getPageRequest());

        var pagingVo = PagingVO.<DynamicBoFieldDefinitionDO>builder()
                .total(page.getTotalElements())
                .setRecords(page.getContent());
        return pagingVo;
    }

    @Override
    public List<DynamicBoFieldDefinitionDO> searchBoFieldList(BoFieldQueryParam boFieldParam) {
        // 获取所有自定义字段
        Predicate predicate = DynamicBoFieldDefinitionService.getPredicateByBoFieldQueryParam(boFieldParam);
        List<DynamicBoFieldDefinitionDO> doList = new ArrayList<>();
        repository.findAll(predicate).iterator().forEachRemaining(boFieldDefinitionDo -> {
            doList.add(boFieldDefinitionDo);
        });
        return doList;
    }

    @Override
    public List<DynamicBoFieldDefinitionDO> getBoModelByCodeList(String boModelCode) {
        BoFieldQueryParam boFieldParam = new BoFieldQueryParam();
        boFieldParam.setBasicModuleCode(boModelCode);
        // 获取所有自定义字段
        Predicate predicate = DynamicBoFieldDefinitionService.getPredicateByBoFieldQueryParam(boFieldParam);
        List<DynamicBoFieldDefinitionDO> doList = new ArrayList<>();
        repository.findAll(predicate).iterator().forEachRemaining(boFieldDefinitionDo -> {
            doList.add(boFieldDefinitionDo);
        });
        return doList;
    }




}
