package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorBoModelRelationDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAndConfiguratorRelation;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorRelationBoModelParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.ConfiguratorRelationBoModelVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorBoModelRelationRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorBoModelRelationService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 14:06
 */
@Service
public class DynamicConfiguratorBoModelRelationServiceImpl implements DynamicConfiguratorBoModelRelationService {

    private final BoModelRepository repository;

    private final ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository;

    private final DynamicBoModelService boModelService;

    private final DynamicConfiguratorService dynamicConfiguratorService;

    private final DynamicBoFieldDefinitionService boFieldDefinitionService;
    public DynamicConfiguratorBoModelRelationServiceImpl(BoModelRepository repository, ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository, DynamicBoModelService boModelService, DynamicConfiguratorService dynamicConfiguratorService, DynamicBoFieldDefinitionService boFieldDefinitionService) {
        this.repository = repository;
        this.configuratorBoModelRelationRepository = configuratorBoModelRelationRepository;
        this.boModelService = boModelService;
        this.dynamicConfiguratorService = dynamicConfiguratorService;
        this.boFieldDefinitionService = boFieldDefinitionService;
    }

    @Override
    @Transactional
    public ApiResult<Long> createBoModelAndConfigurator(BoModelAndConfiguratorRelation boModelParam) {
        BoModelSaveParam boSaveModelParam = new BoModelSaveParam();
        boSaveModelParam.setBoModelCode(boModelParam.getBoModelCode());
        boSaveModelParam.setDatabaseTableName(boModelParam.getDatabaseTableName());
        boSaveModelParam.setDescription(boModelParam.getDescription());
        ApiResult<Long>  result = boModelService.createBoModel(boSaveModelParam);
        boModelAndConfiguratorRelation(boModelParam);
        return result;
    }

    @Override
    @Transactional
    public ApiResult<String> boModelAndConfiguratorRelation(BoModelAndConfiguratorRelation boModelParam) {
        DynamicConfiguratorBoModelRelationDO rdo = new DynamicConfiguratorBoModelRelationDO();
        rdo.setDynamicConfiguratorCode(boModelParam.getDynamicConfiguratorCode());
        rdo.setBoModelCode(boModelParam.getBoModelCode());
        rdo.setBoModelType(boModelParam.getBoModelType());
        configuratorBoModelRelationRepository.save(rdo);
        return ApiResult.ok(rdo.getId().toString());
    }

    @Override
    public ApiResult<String> removeBoModelAndConfiguratorRelation(BoModelAndConfiguratorRelation boModelParam) {
        var predicate = DynamicConfiguratorBoModelRelationService.getPredicateByParam(boModelParam);
        configuratorBoModelRelationRepository.findAll(predicate).forEach(dynamicConfiguratorBoModelRelationDo -> {
            configuratorBoModelRelationRepository.deleteById(dynamicConfiguratorBoModelRelationDo.getId());
        });
        return ApiResult.ok();
    }
    @Override
    @Transactional
    public void deleteConfigurator(Long configuratorId) {
        DynamicConfiguratorDO dynamicConfiguratorDO = dynamicConfiguratorService.getConfiguratorById(configuratorId);

        ConfiguratorRelationBoModelParam configuratorRelationBoModelParam = new ConfiguratorRelationBoModelParam();
        configuratorRelationBoModelParam.setDynamicConfiguratorCode(dynamicConfiguratorDO.getDynamicConfiguratorCode());
        ApiResult<ConfiguratorRelationBoModelVO> configuratorRelationBoModelVOApiResult =
                this.getConfiguratorRelationBoModel(configuratorRelationBoModelParam);
        //循环删除模型和模型的字段
        if (configuratorRelationBoModelVOApiResult.isSuccess()
                && configuratorRelationBoModelVOApiResult.getData() != null) {
            ConfiguratorRelationBoModelVO relationVo = configuratorRelationBoModelVOApiResult.getData();
            List<DynamicBoModelVo> boModelVoList = relationVo.getBoModelVo();
            boModelVoList.forEach(vo -> {
                boModelService.deleteBoModel(vo.getBoModelCode());
                boFieldDefinitionService.deleteByBoCode(vo.getBoModelCode());
            });
        }

        //删除配置能力和模型关系数据
        BoModelAndConfiguratorRelation boModelAndConfiguratorRelation = new BoModelAndConfiguratorRelation();
        boModelAndConfiguratorRelation.setDynamicConfiguratorCode(dynamicConfiguratorDO.getDynamicConfiguratorCode());
        this.removeBoModelAndConfiguratorRelation(boModelAndConfiguratorRelation);

        //删除配置能力数据
        dynamicConfiguratorService.deleteConfigurator(configuratorId);
    }

    @Override
    public ApiResult<ConfiguratorRelationBoModelVO> getConfiguratorRelationBoModel(ConfiguratorRelationBoModelParam param) {

        var configDo = dynamicConfiguratorService.getConfiguratorByCode(param.getDynamicConfiguratorCode());
        if (configDo == null) {
            return ApiResult.fail("未找到配置");
        }
        ConfiguratorRelationBoModelVO configuratorRelationBoModelVO = new ConfiguratorRelationBoModelVO();
        configuratorRelationBoModelVO.setDynamicConfiguratorDo(configDo);

        BoModelAndConfiguratorRelation boModelParam = new BoModelAndConfiguratorRelation();
        boModelParam.setDynamicConfiguratorCode(param.getDynamicConfiguratorCode());
        var predicate = DynamicConfiguratorBoModelRelationService.getPredicateByParam(boModelParam);

        List<DynamicBoModelVo> list = new ArrayList<>();
        configuratorBoModelRelationRepository.findAll(predicate).
                iterator().forEachRemaining(dynamicConfiguratorBoModelRelationDo -> {
                    DynamicBoModelVo boModelVo = boModelService.getBoModelVoByCode(dynamicConfiguratorBoModelRelationDo.getBoModelCode());
                    boModelVo.setBoModelType(dynamicConfiguratorBoModelRelationDo.getBoModelType());
                    list.add(boModelVo);
                });
        configuratorRelationBoModelVO.setBoModelVo(list);

        return ApiResult.ok(configuratorRelationBoModelVO);
    }

}
