package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorService;
import com.querydsl.core.types.Predicate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:31
 */
@Service
public class DynamicConfiguratorServiceImpl implements DynamicConfiguratorService {

    @Autowired
    private ConfiguratorRepository repository;

    @Override
    @Transactional
    public ApiResult<Long> createConfigurator(ConfiguratorSaveParam configuratorParam) {
        ConfiguratorQueryParam qParam = new ConfiguratorQueryParam();
        qParam.setDynamicConfiguratorCode(configuratorParam.getDynamicConfiguratorCode());
        var predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(qParam);
        var configurator = repository.findOne(predicate);
        if (configurator.isPresent()) {
            return ApiResult.fail("编号不能重复：" + configuratorParam.getDynamicConfiguratorCode());
        }

        DynamicConfiguratorDO configuratorEntity = new DynamicConfiguratorDO();
        BeanUtils.copyProperties(configuratorParam, configuratorEntity);
        repository.save(configuratorEntity);
        return ApiResult.ok(configuratorEntity.getId());
    }

    @Override
    public DynamicConfiguratorDO getConfiguratorById(Long id) {
        return repository.findById(id)
                .orElseThrow(() -> new RuntimeException("未找到该ID的配置器 :: " + id));
    }

    @Override
    public DynamicConfiguratorDO getConfiguratorByCode(String configuratorCode) {
        ConfiguratorQueryParam qParam = new ConfiguratorQueryParam();
        qParam.setDynamicConfiguratorCode(configuratorCode);
        var predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(qParam);
        var configuratorDo = repository.findOne(predicate).orElse(null);
        return configuratorDo;
    }

    @Override
    @Transactional
    public ApiResult<Boolean> updateConfigurator(Long id, ConfiguratorUpdateParam configuratorDetails) {
        DynamicConfiguratorDO configurator = repository.findById(id)
                .orElseThrow(() -> new RuntimeException("未找到该ID的配置器 :: " + id));
//        DbConfiguratorConvert.INSTANCE.voToDo(configuratorDetails,configurator);
        if (configuratorDetails.getDynamicConfiguratorName() != null) {
            configurator.setDynamicConfiguratorName(configuratorDetails.getDynamicConfiguratorName());
        }
        if (configuratorDetails.getDynamicConfiguratorType() != null) {
            configurator.setDynamicConfiguratorType(configuratorDetails.getDynamicConfiguratorType());
        }
        if (configuratorDetails.getLayoutTemplateCode() != null) {
            configurator.setLayoutTemplateCode(configuratorDetails.getLayoutTemplateCode());
        }
        if (configuratorDetails.getLayoutTemplateName() != null) {
            configurator.setLayoutTemplateName(configuratorDetails.getLayoutTemplateName());
        }
        if (configuratorDetails.getDynamicConfiguratorStatus() != null) {
            configurator.setDynamicConfiguratorStatus(configuratorDetails.getDynamicConfiguratorStatus());
        }
        if (configuratorDetails.getDynamicConfiguratorDescription() != null) {
            configurator.setDynamicConfiguratorDescription(configuratorDetails.getDynamicConfiguratorDescription());
        }
        if (configuratorDetails.getFrontendExtensionJson() != null) {
            configurator.setFrontendExtensionJson(configuratorDetails.getFrontendExtensionJson());
        }
        repository.save(configurator);
        return ApiResult.ok(true);
    }

    @Override
    @Transactional
    public void deleteConfigurator(Long id) {
        repository.deleteById(id);
    }

    @Override
    public ApiResult<PagingVO<DynamicConfiguratorDO>> searchConfigurators(ConfiguratorQueryParam configuratorParam) {
        Predicate predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(configuratorParam);
        Page<DynamicConfiguratorDO> page = repository.findAll(predicate, configuratorParam.getPageRequest());
        PagingVO<DynamicConfiguratorDO> pagingVO = PagingVO.<DynamicConfiguratorDO>builder()
                .total(page.getTotalElements())
                .setRecords(page.getContent());
        return ApiResult.ok(pagingVO);
    }

    @Override
    public ApiResult<List<DynamicConfiguratorDO>> searchConfiguratorList(ConfiguratorQueryParam configuratorParam) {
        Predicate predicate = DynamicConfiguratorService.getPredicateByConfiguratorQueryParam(configuratorParam);
        List<DynamicConfiguratorDO> doList = new ArrayList<>();
        repository.findAll(predicate).iterator().forEachRemaining(configuratorDo -> {
            doList.add(configuratorDo);
        });
        return ApiResult.ok(doList);
    }
}