package com.elitescloud.cloudt.lowcode.dynamic.service.spi.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 流程定义信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/24
 */
@Getter
@Setter
@ApiModel(description = "流程定义信息")
public class ProcDefInfo implements Serializable {
    private static final long serialVersionUID = -1105775574540885436L;

    @ApiModelProperty(value = "流程ID", position = 1)
    private String id;

    @ApiModelProperty(value = "流程定义Key", position = 1)
    private String key;

    @ApiModelProperty(value = "流程分类ID", position = 2)
    private String categoryId;

    @ApiModelProperty(value = "流程分类名称", position = 3)
    private String categoryName;

    @ApiModelProperty(value = "流程名称", position = 4)
    private String name;

    @ApiModelProperty(value = "流程状态", position = 5)
    private String status;

    @ApiModelProperty(value = "流程状态名称", position = 6)
    private String statusName;

    @ApiModelProperty(value = "微服务访问前缀", position = 7)
    private String appPrefixUrl;

    @ApiModelProperty(value = "是否使用流程表单", position = 8)
    private Boolean form;

    @ApiModelProperty(value = "功能模块编码", position = 9)
    private String moduleCode;

    @ApiModelProperty(value = "功能模块名称", position = 10)
    private String moduleName;

    @ApiModelProperty(value = "扩展信息", position = 21)
    private Map<String, Object> extensions;
}
