package com.elitescloud.cloudt.lowcode.dynamic.service.verify;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-08 16:04
 */
import com.fasterxml.jackson.databind.JsonNode;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import java.io.IOException;

public class JsonValidator {

    public boolean validateJson(String jsonData, String schemaJson) {
        try {
            JsonNode dataNode = JsonLoader.fromString(jsonData);
            JsonNode schemaNode = JsonLoader.fromString(schemaJson);
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            JsonSchema schema = factory.getJsonSchema(schemaNode);
            ProcessingReport report = schema.validate(dataNode);
            return report.isSuccess();
        } catch (IOException | ProcessingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        JsonValidator tester = new JsonValidator();
        tester.testValidation();
    }

    public void testValidation() {
        String jsonData = "{\"name\": \"John\", \"age\": \"3\"}";
        String schemaJson = "{\"type\": \"object\", \"properties\": {\"name\": {\"type\": \"string\"}, \"age\": {\"type\": \"number\"}}}";

        boolean validationResult = validateJson(jsonData, schemaJson);

        if (validationResult) {
            System.out.println("JSON data is valid according to the schema.");
        } else {
            System.out.println("JSON data is not valid according to the schema.");
        }
    }

}
