/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorService;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dynamic/configurators"})
@Api(value="\u914d\u7f6e\u80fd\u529b-\u914d\u7f6e\u7ba1\u7406", tags={"\u914d\u7f6e\u80fd\u529b-\u914d\u7f6e\u7ba1\u7406"})
public class DynamicConfiguratorController {
    @Autowired
    private DynamicConfiguratorService configuratorService;

    @PostMapping
    @GetMapping(value={"/createConfigurator"})
    public ApiResult<Long> createConfigurator(@RequestBody ConfiguratorSaveParam configuratorParam) {
        return this.configuratorService.createConfigurator(configuratorParam);
    }

    @GetMapping(value={"/getConfiguratorById/{id}"})
    public ApiResult<DynamicConfiguratorDO> getConfiguratorById(@PathVariable Long id) {
        DynamicConfiguratorDO configurator = this.configuratorService.getConfiguratorById(id);
        return ApiResult.ok((Object)((Object)configurator));
    }

    @GetMapping(value={"/getConfiguratorByCode/{code}"})
    public ApiResult<DynamicConfiguratorDO> getConfiguratorByCode(@PathVariable String code) {
        DynamicConfiguratorDO configurator = this.configuratorService.getConfiguratorByCode(code);
        return ApiResult.ok((Object)((Object)configurator));
    }

    @PutMapping(value={"/updateConfigurator/{id}"})
    public ApiResult<Boolean> updateConfigurator(@PathVariable Long id, @RequestBody ConfiguratorUpdateParam configuratorDetails) {
        return this.configuratorService.updateConfigurator(id, configuratorDetails);
    }

    @DeleteMapping(value={"/deleteConfigurator/{id}"})
    public ApiResult<Boolean> deleteConfigurator(@PathVariable Long id) {
        this.configuratorService.deleteConfigurator(id);
        return ApiResult.ok((Object)true);
    }

    @PostMapping(value={"/query/page"})
    public ApiResult<PagingVO<DynamicConfiguratorDO>> queryConfigurators(@RequestBody ConfiguratorQueryParam configuratorParam) {
        return this.configuratorService.searchConfigurators(configuratorParam);
    }

    @PostMapping(value={"/query/list"})
    public ApiResult<List<DynamicConfiguratorDO>> queryConfiguratorList(@RequestBody ConfiguratorQueryParam configuratorParam) {
        return this.configuratorService.searchConfiguratorList(configuratorParam);
    }
}

