package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

import cn.hutool.Hutool;
import cn.hutool.db.meta.Column;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 11:47
 */
@Data
@Entity
@Table(name = "lowcode_db_field", indexes = {
})
@Comment("数据库字段")
public class DbFieldDo extends BaseModel {
    private String tableCatalog; // 数据库的目录名（通常是可以忽略的）
    private String tableSchema; // 数据库的模式名
    private String dbTableName; //表名
    private String dbFieldName; // 字段名
    /**
     * 类型，对应java.sql.Types中的类型
     */
    private int type;
    private String dbFieldType; // 字段类型（如：VARCHAR, INT, DATE等）
    private Integer dbFieldLength; // 字段长度（对于某些类型如VARCHAR是必要的）
    private Integer dbFieldPrecision; // 精度，主要用于数值类型，如DECIMAL
    private Integer dbFieldScale; // 小数位数，与precision搭配使用
    private Boolean dbFieldNullable; // 字段是否可以为NULL
    private String dbFieldDefaultValue; // 字段的默认值
    private Boolean dbFieldPrimaryKey; // 字段是否是主键
    private Boolean dbFieldUnique; // 字段值是否需要唯一
    private Boolean dbFieldIndex; // 是否为该字段创建索引
    private String dbFieldForeignTable; // 外键关联的表名
    private String dbFieldForeignField; // 外键关联的字段名
    private String dbFieldCheckConstraint; // 字段检查约束表达式
    private String dbFieldConstraints; // 其他约束（如CHECK约束的表达式）
    private String dbFieldDescription; // 字段描述
    private Boolean dbFieldVirtualField; // 是否为虚拟/计算字段
    private String dbFieldCalculationExpression; // 用于虚拟字段的计算表达式
    private Boolean dbFieldAutoIncrement; // 是否自增
    private String dbFieldCollation; // 字符集和排序规则，主要用于字符串类型
    private Integer dbOrder; // 字符集和排序规则，主要用于字符串类型

    public DbFieldDo hutoolColumnToDo(Column column) {
        this.setDbTableName(column.getTableName());
        this.setDbFieldName(column.getName());
        this.setType(column.getType());
        this.setDbFieldType(column.getTypeName());
        this.setDbFieldLength((int) column.getSize());
        this.setDbFieldPrecision(column.getDigit());
        this.setDbFieldNullable(column.isNullable());
        this.setDbFieldDescription(column.getComment());
        this.setDbFieldAutoIncrement(column.isAutoIncrement());
        this.setDbFieldDefaultValue(column.getColumnDef());
        this.setDbFieldPrimaryKey(column.isPk());
        return this;
    }
}
