package com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp;

import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.ProcDefInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 审批设计信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/24
 */
@Getter
@Setter
@ApiModel(description = "审批设计信息")
public class DynamicConfiguratorApprovalRespVO implements Serializable {
    private static final long serialVersionUID = -7558555696108735541L;

    @ApiModelProperty(value = "是否已创建审批流程", position = 1)
    private Boolean createdApproval;

    @ApiModelProperty(value = "流程审批类型，UDC[cloudt-system:approveType]", position = 2)
    private String approvalType;
    @ApiModelProperty(value = "流程审批类型名称", position = 3)
    private String approvalTypeName;

    @ApiModelProperty(value = "工作流引擎", position = 4)
    private String approvalEngine;
    @ApiModelProperty(value = "工作流引擎名称", position = 5)
    private String approvalEngineName;

    @ApiModelProperty(value = "工作流引擎状态，UDC[cloudt-system:workflowEngineStatus]", position = 6)
    private String engineState;
    @ApiModelProperty(value = "工作流引擎状态名称", position = 7)
    private String engineStateName;

    @ApiModelProperty(value = "工作流引擎异常信息", position = 8)
    private String engineExpMsg;

    @ApiModelProperty(value = "流程定义Key", position = 9)
    private String approvalKey;

    @ApiModelProperty(value = "流程定义信息", position = 11)
    private ProcDefInfo procDefInfo;

    @ApiModelProperty(value = "流程配置扩展信息", position = 21)
    private Map<String, Object> approvalJson;
}
