package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import org.jooq.Field;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 数据库审计字段服务接口
 * 提供填充审计字段和获取当前用户及租户ID的能力
 *
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 10:05
 */
public interface DbAuditFieldService {

    /**
     * 填充插入操作时的审计字段
     *
     * @param entityData 实体数据的Map，键为字段名，值为字段值
     */
    void fillInsertAuditFields(Map<String, Object> entityData);

    /**
     * 填充更新操作时的审计字段
     *
     * @param entityData 实体数据的Map，键为字段名，值为字段值
     */
    void fillUpdateAuditFields(Map<String, Object> entityData);

    /**
     * 获取当前操作用户的ID
     *
     * @return 当前用户ID，Long类型
     */
    Long getCurrentUserId();

    /**
     * 获取当前操作租户的ID
     *
     * @return 当前租户ID，Long类型
     */
    Long getCurrentTenantId();

    List<Field> getAuditFields();
}

