package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.DbModelConvert;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbFieldDo;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDbFieldDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbFieldVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DbFieldRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbFieldRelationService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbFieldService;
import com.querydsl.core.types.Predicate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 15:11
 */
@Service
public class DbFieldServiceImpl implements DbFieldService {

    private final DbFieldRepository dbFieldRepository;
    private final DbFieldRelationService dbFieldRelationService;

    public DbFieldServiceImpl(DbFieldRepository dbFieldRepository, DbFieldRelationService dbFieldRelationService) {
        this.dbFieldRepository = dbFieldRepository;
        this.dbFieldRelationService = dbFieldRelationService;
    }

    @Override
    public List<DbFieldVo> findByTableName(String tableName) {
        var QDO = QDbFieldDo.dbFieldDo;
        Predicate predicate = JpaPredicateBuilder.builder()
                .and(QDO.dbTableName::eq, tableName)
                .getPredicate();
        List<DbFieldVo> dbFields= new ArrayList<>();
                dbFieldRepository.findAll(predicate).iterator().forEachRemaining(dbField -> {
                    dbFields.add(DbModelConvert.INSTANCE.dbFieldDoToVo(dbField));
        });
        return dbFields;
    }


    @Override
    public List<DbFieldDo> findAll() {
        return dbFieldRepository.findAll();
    }

    @Override
    public DbFieldDo findById(Long id) {
        return dbFieldRepository.findById(id).orElse(null);
    }

    @Override
    public DbFieldDo save(DbFieldDo dbField) {
        return dbFieldRepository.save(dbField);
    }

    @Override
    public void delete(Long id) {
        dbFieldRepository.deleteById(id);
    }

    // 收集并存储指定表的字段元数据
//    @Override
//    @Transactional
//    public ApiResult<String> storeFieldsMetadata(String schema, String tableName) {
//        List<DbFieldDo> dbFields = dbMetadataService.getDbTableFieldDo(schema, tableName);
//        dbFieldRepository.deleteByDbTableName(tableName);
//        dbFieldRepository.saveAll(dbFields);
//        return ApiResult.ok("采集表字段共计：" + dbFields.size());
//    }
}