/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataMetaUtil;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DbDataSourceMetadataServiceImpl
implements DbDataSourceMetadataService {
    private static final Logger log = LoggerFactory.getLogger(DbDataSourceMetadataServiceImpl.class);
    private final DataSource dataSource;

    public DbDataSourceMetadataServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getSchema() throws SQLException {
        return DbDataMetaUtil.getSchema((Connection)this.dataSource.getConnection());
    }

    @Override
    public Table getTableMeta(String catalog, String schema, String tableName) {
        return DbDataMetaUtil.getTableMeta((DataSource)this.dataSource, (String)catalog, (String)schema, (String)tableName);
    }

    @Override
    public List<String> getAllTableNames() {
        return DbDataMetaUtil.getTables((DataSource)this.dataSource);
    }

    @Override
    public List<String> getAllTableColumnNames(String catalog, String schema, String tableName) {
        if (schema == null || schema.isBlank()) {
            return List.of(DbDataMetaUtil.getColumnNames((DataSource)this.dataSource, (String)tableName));
        }
        return List.of(DbDataMetaUtil.getColumnNamesByCatalog(this.dataSource, catalog, schema, tableName));
    }

    @Override
    public List<String> getSchemaTableNames(String catalog, String schema) {
        return DbDataMetaUtil.getTablesByCatalog(this.dataSource, catalog, schema, new TableType[0]);
    }
}

