/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldBatchSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbFieldBaseModel;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoFieldDefinitionRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicBoFieldDefinitionServiceImpl
implements DynamicBoFieldDefinitionService {
    private final BoFieldDefinitionRepository repository;
    private final BoModelRepository boModelRepository;

    public DynamicBoFieldDefinitionServiceImpl(BoFieldDefinitionRepository repository, BoModelRepository boModelRepository) {
        this.repository = repository;
        this.boModelRepository = boModelRepository;
    }

    @Override
    @Transactional
    public ApiResult<Long> createBoField(BoFieldDefinitionSaveParam boFieldParam) {
        boolean hasUpperCase = boFieldParam.getBasicKey().matches(".*[A-Z].*");
        if (hasUpperCase) {
            return ApiResult.fail((String)"\u5b57\u6bb5key\u4e0d\u80fd\u5305\u542b\u5927\u5199\u5b57\u6bcd");
        }
        DynamicBoModelDO boDo = this.boModelRepository.findByBoModelCode(boFieldParam.getBasicModuleCode()).orElseThrow(() -> new RuntimeException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728"));
        QDynamicBoFieldDefinitionDO QDO = QDynamicBoFieldDefinitionDO.dynamicBoFieldDefinitionDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)QDO.basicKey).eq(arg_0), (Object)boFieldParam.getBasicKey()).and(arg_0 -> ((StringPath)QDO.basicModuleCode).eq(arg_0), (Object)boFieldParam.getBasicModuleCode()).and(arg_0 -> ((StringPath)QDO.businessObjectCode).eq(arg_0), (Object)boFieldParam.getBusinessObjectCode()).getPredicate();
        boolean exists = (Boolean)this.repository.findBy(predicate, fetchableFluentQuery -> fetchableFluentQuery.exists());
        if (exists) {
            return ApiResult.fail((String)"\u5b57\u6bb5key\u4e0d\u80fd\u91cd\u590d");
        }
        DbFieldBaseModel dbFieldBaseModel = boFieldParam.getDbFieldBaseModel();
        DynamicBoFieldDefinitionDO boFieldDefinitionEntity = new DynamicBoFieldDefinitionDO();
        if (dbFieldBaseModel != null) {
            BeanUtils.copyProperties((Object)dbFieldBaseModel, (Object)((Object)boFieldDefinitionEntity));
        }
        BeanUtils.copyProperties((Object)boFieldParam, (Object)((Object)boFieldDefinitionEntity));
        this.repository.save((Object)boFieldDefinitionEntity);
        return ApiResult.ok((Object)boFieldDefinitionEntity.getId());
    }

    @Override
    @Transactional
    public ApiResult boFieldBatchSave(BoFieldBatchSaveParam param) {
        if (param == null || param.getBasicModuleCode() == null || param.getBoFieldDefinitionSaveParam() == null) {
            return ApiResult.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.repository.deleteByBasicModuleCode(param.getBasicModuleCode());
        for (BoFieldDefinitionSaveParam boFieldDefinitionSaveParam : param.getBoFieldDefinitionSaveParam()) {
            this.createBoField(boFieldDefinitionSaveParam);
        }
        return ApiResult.ok();
    }

    @Override
    public DynamicBoFieldDefinitionDO getBoFieldById(Long id) {
        return (DynamicBoFieldDefinitionDO)((Object)this.repository.findById(id).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5ID\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5 :: " + id)));
    }

    @Transactional
    public ApiResult<Boolean> updateBoField(Long id, BoFieldDefinitionUpdateParam boFieldDetails) {
        DynamicBoFieldDefinitionDO boField = (DynamicBoFieldDefinitionDO)((Object)this.repository.findById(id).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5ID\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5 :: " + id)));
        DbFieldBaseModel dbFieldBaseModel = boFieldDetails.getDbFieldBaseModel();
        if (dbFieldBaseModel != null) {
            BeanUtils.copyProperties((Object)dbFieldBaseModel, (Object)((Object)boField));
        }
        BeanUtils.copyProperties((Object)boFieldDetails, (Object)((Object)boField));
        this.repository.save((Object)boField);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional
    public void deleteBoField(Long id) {
        this.repository.deleteById(id);
    }

    @Override
    public void deleteByBoCode(String boModelCode) {
        this.repository.deleteByBasicModuleCode(boModelCode);
    }

    @Override
    public PagingVO<DynamicBoFieldDefinitionDO> searchBoFields(BoFieldQueryParam boFieldParam) {
        Predicate predicate = DynamicBoFieldDefinitionService.getPredicateByBoFieldQueryParam(boFieldParam);
        Page page = this.repository.findAll(predicate, (Pageable)boFieldParam.getPageRequest());
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.getContent());
        return pagingVo;
    }

    @Override
    public List<DynamicBoFieldDefinitionDO> searchBoFieldList(BoFieldQueryParam boFieldParam) {
        Predicate predicate = DynamicBoFieldDefinitionService.getPredicateByBoFieldQueryParam(boFieldParam);
        ArrayList<DynamicBoFieldDefinitionDO> doList = new ArrayList<DynamicBoFieldDefinitionDO>();
        this.repository.findAll(predicate).iterator().forEachRemaining(boFieldDefinitionDo -> doList.add((DynamicBoFieldDefinitionDO)((Object)boFieldDefinitionDo)));
        return doList;
    }

    @Override
    public List<DynamicBoFieldDefinitionDO> getBoModelByCodeList(String boModelCode) {
        BoFieldQueryParam boFieldParam = new BoFieldQueryParam();
        boFieldParam.setBasicModuleCode(boModelCode);
        Predicate predicate = DynamicBoFieldDefinitionService.getPredicateByBoFieldQueryParam(boFieldParam);
        ArrayList<DynamicBoFieldDefinitionDO> doList = new ArrayList<DynamicBoFieldDefinitionDO>();
        this.repository.findAll(predicate).iterator().forEachRemaining(boFieldDefinitionDo -> doList.add((DynamicBoFieldDefinitionDO)((Object)boFieldDefinitionDo)));
        return doList;
    }
}

