/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorBoModelRelationRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbAuditFieldService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DatabaseTableOperations;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelDbService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicUtil;
import java.util.ArrayList;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicBoModelDbServiceImpl
implements DynamicBoModelDbService {
    private static final Logger log = LoggerFactory.getLogger(DynamicBoModelDbServiceImpl.class);
    private final BoModelRepository repository;
    private final ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository;
    private final DynamicBoFieldDefinitionService boFieldDefinitionService;
    private final DatabaseTableOperations dbDatabaseService;
    private final DynamicBoModelService boModelService;
    private final DbAuditFieldService dbAuditFieldService;

    public DynamicBoModelDbServiceImpl(BoModelRepository repository, ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository, DynamicBoFieldDefinitionService boFieldDefinitionService, DatabaseTableOperations dbDatabaseService, DynamicBoModelService boModelService, DbAuditFieldService dbAuditFieldService) {
        this.repository = repository;
        this.configuratorBoModelRelationRepository = configuratorBoModelRelationRepository;
        this.boFieldDefinitionService = boFieldDefinitionService;
        this.dbDatabaseService = dbDatabaseService;
        this.boModelService = boModelService;
        this.dbAuditFieldService = dbAuditFieldService;
    }

    @Override
    @Transactional
    public ApiResult<String> createBoModelDbTable(String boModelCode) {
        DynamicBoModelVo dynamicBoModelVo = this.boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
            if (dynamicBoModelVo.getCreationTable() != null && dynamicBoModelVo.getCreationTable().booleanValue()) {
                return ApiResult.fail((String)"\u6a21\u578b\u8868\u5df2\u7ecf\u521b\u5efa\u72b6\u6001");
            }
            List<DynamicBoFieldDefinitionDO> dynamicBoFieldDefinitionDOList = dynamicBoModelVo.getDynamicBoFieldDefinitionDoList();
            if (dynamicBoFieldDefinitionDOList != null) {
                ArrayList<Field> fields = new ArrayList<Field>();
                dynamicBoFieldDefinitionDOList.forEach(fieldDefinitionDo -> {
                    if (fieldDefinitionDo.getDbField().booleanValue()) {
                        Field<?> jooqField = DynamicUtil.getJooqField(fieldDefinitionDo);
                        fields.add(jooqField);
                    }
                });
                List<Field> fieldList = this.dbAuditFieldService.getAuditFields();
                fields.addAll(fieldList);
                Field[] fieldArray = fields.toArray(new Field[0]);
                this.dbDatabaseService.createTable(dynamicBoModelVo.getDatabaseTableName(), fieldArray);
                this.boModelService.updateCreateTable(boModelCode, true);
            }
        } else {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684BO\u6a21\u578b");
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public ApiResult<String> deleteBoModelDbTable(String boModelCode) {
        DynamicBoModelVo dynamicBoModelVo = this.boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo == null) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684BO\u6a21\u578b");
        }
        String tableName = dynamicBoModelVo.getDatabaseTableName();
        this.dbDatabaseService.dropTable(tableName);
        this.boModelService.updateCreateTable(boModelCode, false);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> deleteAndCreatBoModelDbTable(String boModelCode) {
        try {
            ApiResult<String> apiResult = this.deleteBoModelDbTable(boModelCode);
            if (apiResult.isSuccess()) {
                return this.createBoModelDbTable(boModelCode);
            }
            log.info(apiResult.getMsg());
            return apiResult;
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5bf9\u8c61\u6a21\u578b\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage());
            return ApiResult.fail((String)("\u4e1a\u52a1\u5bf9\u8c61\u6a21\u578b\u6570\u636e\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    @Override
    @Transactional
    public ApiResult<String> addBoModelDbField(String boModelCode, DynamicBoFieldDefinitionDO field) {
        DynamicBoModelVo dynamicBoModelVo = this.boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
            String tableName = dynamicBoModelVo.getDatabaseTableName();
            Field<?> jooqField = DynamicUtil.getJooqField(field);
            try {
                this.dbDatabaseService.addField(tableName, jooqField);
            }
            catch (Exception e) {
                return ApiResult.fail((String)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
            }
        } else {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684BO\u6a21\u578b");
        }
        return null;
    }

    @Override
    @Transactional
    public ApiResult<String> updateBoModelDbField(String boModelCode, String fieldName, BoFieldDefinitionUpdateParam newData) {
        DynamicBoModelVo dynamicBoModelVo = this.boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
            String tableName = dynamicBoModelVo.getDatabaseTableName();
            try {
                DataType<?> newDataType = newData.getBasicType().getJooqDataType();
                this.dbDatabaseService.modifyField(tableName, fieldName, newDataType);
            }
            catch (Exception e) {
                return ApiResult.fail((String)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
            }
        } else {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684BO\u6a21\u578b");
        }
        return null;
    }

    @Override
    @Transactional
    public ApiResult<String> deleteBoModelDbField(String boModelCode, String fieldName) {
        DynamicBoModelVo dynamicBoModelVo = this.boModelService.getBoModelVoByCode(boModelCode);
        if (dynamicBoModelVo != null) {
            String tableName = dynamicBoModelVo.getDatabaseTableName();
            try {
                this.dbDatabaseService.dropTable(tableName);
            }
            catch (Exception e) {
                return ApiResult.fail((String)("\u5220\u9664\u5931\u8d25" + e.getMessage()));
            }
        } else {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684BO\u6a21\u578b");
        }
        return null;
    }
}

