/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.spi.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.lowcode.dynamic.common.WorkflowEngineStatusUdc;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.DynamicWorkflowEngine;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.ProcDefInfo;
import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.WorkflowStatus;
import com.elitescloud.cloudt.workflow.params.ProcDefDTO;
import com.elitescloud.cloudt.workflow.params.save.ProcDefSaveDTO;
import com.elitescloud.cloudt.workflow.service.rpc.ProcDefRpcService;
import com.elitescloud.cloudt.workflow.service.rpc.WorkflowRpcService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CloudtDynamicWorkflowEngine
implements DynamicWorkflowEngine {
    private static final Logger logger = LoggerFactory.getLogger(CloudtDynamicWorkflowEngine.class);
    @Autowired
    private WorkflowRpcService workflowRpcService;
    @Autowired
    private ProcDefRpcService procDefRpcService;
    @Autowired
    private UdcProvider udcProvider;

    @Override
    public String engineType() {
        return "cloudt";
    }

    @Override
    public String engineName() {
        return "\u4e91\u68af\u5de5\u4f5c\u6d41";
    }

    @Override
    public WorkflowStatus getEngineStatus() {
        WorkflowStatus workflowStatus = new WorkflowStatus();
        try {
            this.workflowRpcService.ready();
            workflowStatus.setStatus(WorkflowEngineStatusUdc.RUNNING.getValue());
            workflowStatus.setStatusName(this.translateWorkflowStatusName(WorkflowEngineStatusUdc.RUNNING));
        }
        catch (Exception e) {
            logger.error("\u8fde\u63a5\u5de5\u4f5c\u6d41\u5f02\u5e38\uff1a", (Throwable)e);
            workflowStatus.setStatus(WorkflowEngineStatusUdc.CONNECTION_EXP.getValue());
            workflowStatus.setStatusName(this.translateWorkflowStatusName(WorkflowEngineStatusUdc.CONNECTION_EXP));
            workflowStatus.setExpMsg(e.getMessage());
        }
        return workflowStatus;
    }

    @Override
    public ProcDefInfo getProcDefInfo(String procDefKey) {
        ProcDefDTO procDef = null;
        try {
            procDef = (ProcDefDTO)this.procDefRpcService.getProcDef(procDefKey).computeData();
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25", (Throwable)e);
        }
        if (procDef == null) {
            return null;
        }
        ProcDefInfo info = new ProcDefInfo();
        info.setId(procDef.getId().toString());
        info.setKey(procDef.getKey());
        info.setCategoryId(procDef.getCategoryId() == null ? null : procDef.getCategoryId().toString());
        info.setCategoryName(procDef.getCategoryName());
        info.setName(procDef.getName());
        info.setStatus(procDef.getState());
        info.setStatusName(procDef.getStateName());
        info.setAppPrefixUrl(procDef.getAppPrefixUrl());
        return info;
    }

    @Override
    public String createProcDef(ProcDefInfo procDefInfo) {
        ProcDefSaveDTO saveDTO = new ProcDefSaveDTO();
        saveDTO.setId(StringUtils.hasText((String)procDefInfo.getId()) ? Long.valueOf(Long.parseLong(procDefInfo.getId())) : null);
        saveDTO.setCategoryId(StringUtils.hasText((String)procDefInfo.getCategoryId()) ? Long.valueOf(Long.parseLong(procDefInfo.getCategoryId())) : null);
        saveDTO.setName(procDefInfo.getName());
        saveDTO.setKey(procDefInfo.getKey());
        saveDTO.setAppPrefixUrl(procDefInfo.getAppPrefixUrl());
        saveDTO.setForm(procDefInfo.getForm());
        saveDTO.setModuleCode(procDefInfo.getModuleCode());
        saveDTO.setModuleName(procDefInfo.getModuleName());
        try {
            this.procDefRpcService.save(saveDTO);
        }
        catch (Exception e) {
            throw new BusinessException("\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25", (Throwable)e);
        }
        return procDefInfo.getKey();
    }

    @Override
    public String deploy(String procDefKey) {
        try {
            this.procDefRpcService.deploy(procDefKey);
        }
        catch (Exception e) {
            throw new BusinessException("\u90e8\u7f72\u6d41\u7a0b\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return procDefKey;
    }

    @Override
    public String deleteProcDef(String procDefKey) {
        try {
            this.procDefRpcService.deleteByKey(procDefKey);
        }
        catch (Exception e) {
            throw new BusinessException("\u5220\u9664\u6d41\u7a0b\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        return procDefKey;
    }

    private String translateWorkflowStatusName(WorkflowEngineStatusUdc status) {
        Map udcValueMap = this.udcProvider.getValueMapByUdcCode(status.getAppCode(), status.getUdcCode());
        if (CollUtil.isEmpty((Map)udcValueMap)) {
            return status.getDescription();
        }
        return udcValueMap.getOrDefault(status.getValue(), status.getDescription());
    }
}

