/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.elitescloud.boot.excel.util.ExcelUtil;
import com.elitescloud.cloudt.lowcode.dynamic.model.DynamicFieldCondition;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.True;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class DynamicUtil {
    private static final Logger log = LoggerFactory.getLogger(DynamicUtil.class);

    public static LocalDateTime getOperationDateTime(String operationTime) {
        LocalDateTime operationDateTime = null;
        if (operationTime != null) {
            if (operationTime.length() > 19) {
                operationTime = operationTime.substring(0, 19);
            }
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            try {
                operationDateTime = LocalDateTime.parse(operationTime, pattern);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return operationDateTime;
    }

    private static Object getOperationDate(String operationTime) {
        LocalDateTime operationDateTime = null;
        if (operationTime != null) {
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            try {
                operationDateTime = LocalDateTime.parse(operationTime, pattern);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return operationDateTime;
    }

    public static Object transformValue(Object value, DynamicBoFieldDefinitionDO definitionDo) {
        try {
            if (value == null) {
                return null;
            }
            if (definitionDo.getBasicType().getJooqDataType().isNumeric()) {
                return Double.parseDouble(value.toString());
            }
            if (definitionDo.getBasicType().getJooqDataType().isDateTime()) {
                return DynamicUtil.getOperationDateTime(value.toString());
            }
            if (definitionDo.getBasicType().getJooqDataType().isDate()) {
                return DynamicUtil.getOperationDate(value.toString());
            }
        }
        catch (NumberFormatException e) {
            String errMsg = definitionDo.getBasicName() + "\u6570\u503c\u8f6c\u6362\u9519\u8bef" + String.valueOf(value);
            log.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg);
        }
        return value;
    }

    public static Field<?> getJooqField(DynamicBoFieldDefinitionDO field) {
        if (field == null) {
            return null;
        }
        DataType dataType = field.getBasicType().getJooqDataType();
        if (field.getDbFieldLength() != null && dataType.hasLength()) {
            dataType = dataType.length(field.getDbFieldLength().intValue());
        }
        if (field.getDbFieldPrecision() != null && dataType.hasPrecision()) {
            dataType = dataType.precision(field.getDbFieldPrecision().intValue(), field.getDbFieldScale().intValue());
        }
        if (field.getDbFieldNullable() != null) {
            dataType = dataType.nullable(field.getDbFieldNullable().booleanValue());
        }
        Field jooqField = DSL.field((Name)DSL.name((String)field.getBasicKey()), (DataType)dataType);
        return jooqField;
    }

    public static Condition getDynamicFieldQueryParamCondition(DynamicFieldQueryParam queryParam) {
        True condition = DSL.trueCondition();
        if (queryParam.getDynamicFieldConditionList() == null) {
            return condition;
        }
        block19: for (DynamicFieldCondition fieldCondition : queryParam.getDynamicFieldConditionList()) {
            Field field = DSL.field((Name)DSL.name((String)fieldCondition.getField()), Object.class);
            switch (fieldCondition.getCondition()) {
                case Equal: {
                    condition = condition.and(field.eq((Object)fieldCondition.getValue()));
                    continue block19;
                }
                case NotEqual: {
                    condition = condition.and(field.ne((Object)fieldCondition.getValue()));
                    continue block19;
                }
                case GreaterEqual: {
                    condition = condition.and(field.ge((Object)fieldCondition.getValue()));
                    continue block19;
                }
                case GreaterThan: {
                    condition = condition.and(field.gt((Object)fieldCondition.getValue()));
                    continue block19;
                }
                case LessEqual: {
                    condition = condition.and(field.le((Object)fieldCondition.getValue()));
                    continue block19;
                }
                case LessThan: {
                    condition = condition.and(field.lt((Object)fieldCondition.getValue()));
                    continue block19;
                }
                case Contain: {
                    condition = condition.and((Condition)field.like("%" + fieldCondition.getValue() + "%"));
                    continue block19;
                }
                case StartWith: {
                    condition = condition.and((Condition)field.like(fieldCondition.getValue() + "%"));
                    continue block19;
                }
                case EndWith: {
                    condition = condition.and((Condition)field.like("%" + fieldCondition.getValue()));
                    continue block19;
                }
                case Between: {
                    String[] range = fieldCondition.getValue().split(";");
                    condition = condition.and(field.between((Object)range[0], (Object)range[1]));
                    continue block19;
                }
                case NotBetween: {
                    String[] range = fieldCondition.getValue().split(";");
                    condition = condition.and(field.notBetween((Object)range[0], (Object)range[1]));
                    continue block19;
                }
                case InList: {
                    condition = condition.and(field.in(new Object[]{fieldCondition.getValue()}));
                    continue block19;
                }
                case NotIn: {
                    condition = condition.and(field.notIn(new Object[]{fieldCondition.getValue()}));
                    continue block19;
                }
                case IsNull: {
                    condition = condition.and(field.isNull());
                    continue block19;
                }
                case NotNull: {
                    condition = condition.and(field.isNotNull());
                    continue block19;
                }
                case Empty: {
                    condition = condition.and((Condition)field.like(""));
                    continue block19;
                }
                case NotEmpty: {
                    condition = condition.and((Condition)field.notLike(""));
                    continue block19;
                }
            }
            throw new IllegalArgumentException("Unsupported condition: " + String.valueOf(fieldCondition.getCondition()));
        }
        return condition;
    }

    public static void writeResponseXlsx(String tableName, HttpServletResponse response, List<List<String>> head, List<List<Object>> dataList) throws IOException {
        String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
        String encodedFileName = URLEncoder.encode(tableName, "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(encodedFileName + currentTime) + ".xlsx\"");
        ExcelUtil.normalizeExcelWriter((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(head))).sheet("Sheet1").doWrite(dataList);
    }

    public static List<Map<String, Object>> readExcelAsMap(MultipartFile file) throws IOException {
        final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        EasyExcel.read((InputStream)file.getInputStream(), (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){
            private boolean headFlag = true;
            private List<String> headList = new ArrayList<String>();
            private int rowIndex = 0;

            public void invoke(Map<Integer, String> data, AnalysisContext context) {
                if (this.rowIndex > 1) {
                    LinkedHashMap rowMap = new LinkedHashMap();
                    data.forEach((key, value) -> {
                        if (key < this.headList.size()) {
                            rowMap.put(this.headList.get((int)key), value);
                        }
                    });
                    list.add(rowMap);
                }
                ++this.rowIndex;
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }

            public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext context) {
                if (this.rowIndex == 0) {
                    headMap.forEach((key, value) -> this.headList.add(value.getStringValue()));
                }
                ++this.rowIndex;
            }
        }).sheet().doRead();
        return list;
    }
}

