/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicExportParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportFailures;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportResult;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbAuditFieldService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicDbApiService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicUtil;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl.DynamicBoFieldDefinitionServiceImpl;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetStep;
import org.jooq.InsertValuesStepN;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateQuery;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DynamicDbApiServiceImpl
implements DynamicDbApiService {
    private static final Logger log = LoggerFactory.getLogger(DynamicDbApiServiceImpl.class);
    public static final String TENANT_ID = "tenant_id";
    public static final String ID = "id";
    @Autowired
    DSLContext dsl;
    @Autowired
    DynamicBoFieldDefinitionServiceImpl boFieldDefinitionService;
    @Autowired
    DbAuditFieldService dbAuditFieldService;
    @Autowired
    DynamicBoModelService boModelService;

    @Override
    public ApiResult<Object> insert(String tableName, Map<String, Object> entityData) throws Exception {
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionDos(tableName);
        DynamicDbApiServiceImpl.boFiledCheck(boFieldDefinitionDoList, entityData);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        ArrayList fields = new ArrayList();
        ArrayList values = new ArrayList();
        this.dbAuditFieldService.fillInsertAuditFields(entityData);
        entityData.forEach((key, value) -> {
            fields.add(DSL.field((Name)DSL.name((String)key)));
            values.add(value);
        });
        InsertValuesStepN insertStep = this.dsl.insertInto(table).columns(fields).values(values);
        String sql = insertStep.getSQL();
        System.out.println(sql);
        insertStep.execute();
        return ApiResult.ok((Object)entityData.get(ID));
    }

    @Override
    public ApiResult<Integer> update(String tableName, Long id, Map<String, Object> entityData) {
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionDos(tableName);
        DynamicDbApiServiceImpl.boFiledCheck(boFieldDefinitionDoList, entityData);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        UpdateQuery updateQuery = this.dsl.updateQuery(table);
        this.dbAuditFieldService.fillUpdateAuditFields(entityData);
        entityData.forEach((key, value) -> {
            Field field = DSL.field((Name)DSL.name((String)key), Object.class);
            updateQuery.addValue(field, value);
        });
        Field idField = DSL.field((Name)DSL.name((String)ID), Long.class);
        Condition condition = idField.eq((Object)id);
        condition = this.setTenantIdCondition(condition);
        updateQuery.addConditions(condition);
        int rowsUpdated = updateQuery.execute();
        return ApiResult.ok((Object)rowsUpdated);
    }

    @Override
    public ApiResult<Page<?>> queryPage(String tableName, DynamicFieldQueryParam queryParam) {
        Table table = DSL.table((Name)DSL.name((String)tableName));
        SelectJoinStep baseQuery = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)table);
        Condition condition = DynamicUtil.getDynamicFieldQueryParamCondition(queryParam);
        condition = this.setTenantIdCondition(condition);
        SelectConditionStep conditionalQuery = baseQuery.where(condition);
        SortField[] sortFields = (SortField[])queryParam.getOrders().stream().map(order -> {
            Field orderField = DSL.field((Name)DSL.name((String)order.getColumn()), Object.class);
            return order.isAsc() ? orderField.asc() : orderField.desc();
        }).toArray(SortField[]::new);
        conditionalQuery.orderBy((OrderField[])sortFields);
        int offset = queryParam.getCurrent() * queryParam.getSize();
        Result result = conditionalQuery.limit((Number)queryParam.getSize()).offset(offset).fetch();
        int total = (Integer)this.dsl.selectCount().from((TableLike)table).where(condition).fetchOne(0, Integer.TYPE);
        PageImpl pageResult = new PageImpl(result.intoMaps(), (Pageable)PageRequest.of((int)queryParam.getCurrent(), (int)queryParam.getSize()), (long)total);
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<Map> getById(String tableName, Long id) {
        try {
            Table table = DSL.table((Name)DSL.name((String)tableName));
            Condition condition = DSL.field((Name)DSL.name((String)ID)).eq((Object)id);
            condition = this.setTenantIdCondition(condition);
            Record record = this.dsl.selectFrom(table).where(condition).fetchOne();
            if (record == null) {
                return ApiResult.fail((String)"\u672a\u627e\u5230\u6570\u636e");
            }
            Map map = record.intoMap();
            return ApiResult.ok((Object)map);
        }
        catch (Exception e) {
            log.error("\u52a8\u6001\u67e5\u8be2\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u52a8\u6001\u67e5\u8be2\u5f02\u5e38 data by ID: " + e.getMessage()));
        }
    }

    @Override
    public void dynamicExport(String tableName, DynamicExportParam dynamicExportParam, HttpServletResponse response) throws IOException {
        if (dynamicExportParam == null || dynamicExportParam.getFieldMap() == null) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        dynamicExportParam.getFieldMap().forEach((englishName, chineseName) -> {
            ArrayList<String> headerColumn = new ArrayList<String>();
            headerColumn.add((String)englishName);
            headerColumn.add((String)chineseName);
            head.add(headerColumn);
        });
        List selectFields = dynamicExportParam.getFieldMap().keySet().stream().map(DSL::field).collect(Collectors.toList());
        Table table = DSL.table((Name)DSL.name((String)tableName));
        Condition condition = DynamicUtil.getDynamicFieldQueryParamCondition(dynamicExportParam);
        condition = this.setTenantIdCondition(condition);
        Result result = this.dsl.select(selectFields).from((TableLike)table).where(condition).orderBy((OrderField[])dynamicExportParam.getOrders().stream().map(order -> DSL.field((Name)DSL.name((String)order.getColumn()), Object.class).sort(order.isAsc() ? SortOrder.ASC : SortOrder.DESC)).toArray(SortField[]::new)).fetch();
        ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
        if (result != null && result.size() > 0) {
            result.intoMaps().stream().map(map -> map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(stringObjectEntry -> {
                if (Timestamp.class.isAssignableFrom(stringObjectEntry.getClass())) {
                    return ((Timestamp)stringObjectEntry.getValue()).toLocalDateTime();
                }
                return stringObjectEntry.getValue();
            }).collect(Collectors.toList())).collect(Collectors.toList());
        }
        try {
            DynamicUtil.writeResponseXlsx(tableName, response, head, dataList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ApiResult<DynamicImportResult> dynamicImport(String tableName, MultipartFile file) {
        DynamicImportResult dynamicImportResult = new DynamicImportResult();
        List<Map<String, Object>> dataList = null;
        try {
            dataList = DynamicUtil.readExcelAsMap(file);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25" + e.getMessage()));
        }
        Table table = DSL.table((Name)DSL.name((String)tableName));
        int row = 0;
        for (Map<String, Object> rowData : dataList) {
            ++row;
            try {
                InsertSetStep insertStep = this.dsl.insertInto(table);
                this.dbAuditFieldService.fillInsertAuditFields(rowData);
                rowData.forEach((key, value) -> insertStep.set(DSL.field((String)key), value));
                insertStep.columns(new Field[0]).execute();
            }
            catch (Exception e) {
                DynamicImportFailures dynamicImportFailures = new DynamicImportFailures();
                dynamicImportFailures.setFailuresDate(rowData);
                dynamicImportFailures.setFailuresDescription("\u57f7\u884c\u5f02\u5e38\uff1a" + e.getMessage());
                dynamicImportFailures.setFailuresRow(row);
                dynamicImportResult.getFailuresDescription().add(dynamicImportFailures);
                dynamicImportResult.setFailures(dynamicImportResult.getFailures() + 1);
                continue;
            }
            dynamicImportResult.setSuccessful(dynamicImportResult.getSuccessful() + 1);
        }
        return ApiResult.ok((Object)dynamicImportResult);
    }

    @Override
    public ApiResult<?> delete(String tableName, Long id) {
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionDos(tableName);
        if (boFieldDefinitionDoList == null || boFieldDefinitionDoList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230Bo\u5b57\u6bb5");
        }
        Condition condition = DSL.field((Name)DSL.name((String)ID)).eq((Object)id);
        this.setTenantIdCondition(condition);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        this.dsl.deleteFrom(table).where(condition).execute();
        return ApiResult.ok();
    }

    @Override
    public ApiResult<?> deleteBatch(String tableName, List<Long> ids) {
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.getBoFieldDefinitionDos(tableName);
        if (boFieldDefinitionDoList == null || boFieldDefinitionDoList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230Bo\u5b57\u6bb5");
        }
        Condition condition = DSL.field((Name)DSL.name((String)ID)).in(ids);
        this.setTenantIdCondition(condition);
        Table table = DSL.table((Name)DSL.name((String)tableName));
        this.dsl.deleteFrom(table).where(condition).execute();
        return ApiResult.ok();
    }

    private static void boFiledCheck(List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList, Map<String, Object> entityData) {
        if (boFieldDefinitionDoList == null || boFieldDefinitionDoList.isEmpty()) {
            throw new BusinessException("\u672a\u627e\u5230Bo\u5b57\u6bb5");
        }
        if (entityData == null || entityData.size() == 0) {
            throw new BusinessException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<DynamicBoFieldDefinitionDO> getBoFieldDefinitionDos(String tableName) {
        BoFieldQueryParam boFieldParam = new BoFieldQueryParam();
        boFieldParam.setDbField(true);
        boFieldParam.setDbTableName(tableName);
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionDoList = this.boFieldDefinitionService.searchBoFieldList(boFieldParam);
        return boFieldDefinitionDoList;
    }

    private Condition setTenantIdCondition(Condition condition) {
        Long tenantId = this.dbAuditFieldService.getCurrentTenantId();
        if (tenantId == null) {
            tenantId = -1L;
        }
        Field tenantIdField = DSL.field((Name)DSL.name((String)TENANT_ID), Long.class);
        return condition.and(tenantIdField.eq((Object)tenantId));
    }
}

