package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-03 16:52
 */

import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Map;

@Entity
@Table(name = TableNameConstant.DYNAMIC_BO_MODEL, indexes = {
        @Index(name = "idx_dynamicbo_code", columnList = "boModelCode"),
        @Index(name = "idx_dynamicbo_businessobj", columnList = "businessObjectCode"),
        @Index(name = "idx_dynamicbo_table", columnList = "databaseTableName"),
})
@Comment("数据模型")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class DynamicBoModelDO extends BaseModel {
    private static final long serialVersionUID = 8929903972933822205L;

    @Comment("模型编码，唯一标识")
    @Column(nullable = false)
    private String boModelCode;

    @Comment("模型名称")
    @Column()
    private String boModeName;

    @Column()
    @Comment("业务对象编码")
    private String businessObjectCode;

    @Comment("模型对应的数据库表名")
    @Column()
    private String databaseTableName;

    @Comment("模型描述")
    @Column()
    private String description;

    @Comment(value = "是否已创建表", defaultValue = "0")
    @Column()
    private Boolean creationTable;

    @Comment("业务对象模型表单展示JSON")
    @Column()
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> formJson;

    @Comment("业务对象模型列表展示JSON")
    @Column()
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> listPageJson;
}
