package com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 部署记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/25
 */
@Getter
@Setter
@ApiModel(description = "部署记录")
public class DynamicDeployRecordRespVO implements Serializable {
    private static final long serialVersionUID = -1351988737174778497L;

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "部署类型")
    private String deployType;

    @ApiModelProperty(value = "开始部署时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "结束部署时间")
    private LocalDateTime finishTime;

    @ApiModelProperty(value = "是否部署成功")
    private Boolean success;

    @ApiModelProperty(value = "执行结果")
    private String result;

    @ApiModelProperty(value = "执行人")
    private String creator;

    @ApiModelProperty(value = "详细日志")
    private String log;
}
