package com.elitescloud.cloudt.lowcode.dynamic.model.vo.save;

import com.elitescloud.cloudt.lowcode.dynamic.service.spi.common.ProcDefInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * 功能模块的审批设计信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/24
 */
@Getter
@Setter
@ApiModel(description = "功能模块的审批设计信息")
public class DynamicConfiguratorApprovalSaveVO implements Serializable {
    private static final long serialVersionUID = -1222373214860174185L;

    @NotNull(message = "功能模块ID为空")
    @ApiModelProperty(value = "功能模块ID", position = 1, required = true)
    private Long configuratorId;

    @NotNull(message = "流程审批类型为空")
    @ApiModelProperty(value = "流程审批类型，UDC[cloudt-system:approveType]", position = 2, required = true)
    private String approvalType;

    @ApiModelProperty(value = "工作流引擎", position = 3)
    private String approvalEngine;

    @ApiModelProperty(value = "流程定义信息", position = 4)
    private ProcDefInfo procDefInfo;

    @ApiModelProperty(value = "流程配置扩展信息", position = 11)
    private Map<String, Object> approvalJson;

}
