package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbTableVo;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 10:19
 */
public interface DbTableService {
    /**
     * 根据表名查找对应的DbTableVo对象。
     * @param TableName 表名
     * @return DbTableVo对象，如果找到则返回对应的对象，否则返回null。
     */
    DbTableVo findByTableName(String TableName);

    /**
     * 查找所有DbTableDo对象。
     * @return DbTableDo对象列表，包含所有记录。
     */
    List<DbTableDo> findAll();

    /**
     * 根据ID查找对应的DbTableDo对象。
     * @param id 表的ID
     * @return DbTableDo对象，如果找到则返回对应的对象，否则返回null。
     */
    DbTableDo findById(Long id);

    /**
     * 保存或更新一个DbTableDo对象。
     * @param dbTable 要保存或更新的DbTableDo对象
     * @return 保存或更新后的DbTableDo对象。
     */
    DbTableDo save(DbTableDo dbTable);

    /**
     * 根据ID删除一个DbTableDo对象。
     * @param id 要删除的表的ID
     */
    void delete(Long id);


      ApiResult<String> storeTablesAndFieldsMetadata(DbTableParam dbTableParam);
}
