package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorBoModelRelationDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAndConfiguratorRelation;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorRelationBoModelParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.ConfiguratorRelationBoModelVO;
import com.querydsl.core.types.Predicate;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 14:05
 */
public interface DynamicConfiguratorBoModelRelationService {
    static Predicate getPredicateByParam(BoModelAndConfiguratorRelation boModelParam) {
        var QDO = QDynamicConfiguratorBoModelRelationDO.dynamicConfiguratorBoModelRelationDO;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.boModelCode::eq, boModelParam.getBoModelCode())
                .and(QDO.dynamicConfiguratorCode::eq, boModelParam.getDynamicConfiguratorCode())

                .getPredicate();
        return predicate;
    }

    ApiResult<Long> createBoModelAndConfigurator(BoModelAndConfiguratorRelation boModelParam);

    ApiResult<String> boModelAndConfiguratorRelation(BoModelAndConfiguratorRelation boModelParam);

    ApiResult<String> removeBoModelAndConfiguratorRelation(BoModelAndConfiguratorRelation boModelParam);

    void deleteConfigurator(Long configuratorId);

    ApiResult<ConfiguratorRelationBoModelVO> getConfiguratorRelationBoModel(ConfiguratorRelationBoModelParam param);
}
