package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.*;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorBoModelRelationRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DatabaseTableOperations;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.querydsl.core.types.Predicate;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:06
 */
@Service
public class DynamicBoModelServiceImpl implements DynamicBoModelService {


    private final BoModelRepository repository;

    private final ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository;

    private final DynamicBoFieldDefinitionService boFieldDefinitionService;

    private final DatabaseTableOperations dbDatabaseService;

    public DynamicBoModelServiceImpl(BoModelRepository repository,
                                     ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository,
                                     DynamicBoFieldDefinitionService boFieldDefinitionService,
                                     DatabaseTableOperations dbDatabaseService) {
        this.repository = repository;
        this.configuratorBoModelRelationRepository = configuratorBoModelRelationRepository;
        this.boFieldDefinitionService = boFieldDefinitionService;
        this.dbDatabaseService = dbDatabaseService;
    }

    @Override
    @Transactional
    public ApiResult<Long> createBoModel(BoModelSaveParam boModelParam) {
//        var  optionalDynamicBoModelDo = repository.findByBoModelCode(boModelParam.getBoModelCode());
//        if (optionalDynamicBoModelDo.isPresent()) {
//            throw new IllegalStateException("Code不能重复: " + boModelParam.getBoModelCode());
//        }

        BoModelQueryParam qParam = new BoModelQueryParam();
        qParam.setBoModelCode(boModelParam.getBoModelCode());

        var predicate = DynamicBoModelService.getPredicateByBoModelQueryParam(qParam);
        var configurator = repository.findOne(predicate);
        if (configurator.isPresent()) {
            return ApiResult.fail("编号不能重复：" + boModelParam.getBoModelCode());
        }

        DynamicBoModelDO boModelEntity = new DynamicBoModelDO();
        BeanUtils.copyProperties(boModelParam, boModelEntity);
        boModelEntity.setCreationTable(false);
        boModelEntity.setDatabaseTableName("dynamically_"+boModelParam.getBoModelCode());
        repository.save(boModelEntity);
        return ApiResult.ok(boModelEntity.getId());
    }


    @Override
    public DynamicBoModelDO getBoModelByCode(String boModelCode) {
        return repository.findByBoModelCode(boModelCode)
                .orElseThrow(() -> new RuntimeException("未找到该BO模型编码 :: " + boModelCode));
    }

    @Override
    public DynamicBoModelDO getBoModelById(Long boModelId) {
        return repository.findById(boModelId)
                .orElseThrow(() -> new RuntimeException("未找到该BO模型编码 :: " + boModelId));
    }

    @Override
    @Transactional
    public ApiResult<Boolean> updateBoModel(String boModelCode, BoModelUpdateParam boModelDetails) {
        DynamicBoModelDO boModel = repository.findByBoModelCode(boModelCode)
                .orElseThrow(() -> new RuntimeException("未找到该BO模型编码 :: " + boModelCode));
        BeanUtils.copyProperties(boModelDetails, boModel);
        repository.save(boModel);
        return ApiResult.ok(true);
    }

    @Override
    public ApiResult<Boolean> updateBoModelById(Long boModelId, BoModelUpdateParam boModelDetails) {
        DynamicBoModelDO boModel = repository.findById(boModelId)
                .orElseThrow(() -> new RuntimeException("未找到该BO模型编码 :: " + boModelId));
        BeanUtils.copyProperties(boModelDetails, boModel);
        repository.save(boModel);
        return ApiResult.ok(true);
    }

    @Override
    @Transactional
    public ApiResult<Boolean> deleteBoModel(String boModelCode) {
        repository.deleteByBoModelCode(boModelCode);
        boFieldDefinitionService.deleteByBoCode(boModelCode);
        return ApiResult.ok(true);
    }

    @Override
    @Transactional
    public ApiResult<Boolean> deleteBoModelById(Long boModelId) {
      //  repository.deleteById(boModelId);
        DynamicBoModelDO dynamicBoModelDO=getBoModelById(boModelId);
        deleteBoModel(dynamicBoModelDO.getBoModelCode());
        return ApiResult.ok(true);
    }

    @Override
    public PagingVO<DynamicBoModelDO> searchBoModels(BoModelQueryParam boModelParam) {
        Predicate predicate = DynamicBoModelService.getPredicateByBoModelQueryParam(boModelParam);
        Page<DynamicBoModelDO> page = repository.findAll(predicate, boModelParam.getPageRequest());
        return PagingVO.<DynamicBoModelDO>builder()
                .total(page.getTotalElements())
                .setRecords(page.getContent());
    }

    @Override
    public List<DynamicBoModelDO> searchBoModelList(BoModelQueryParam boModelParam) {
        Predicate predicate = DynamicBoModelService.getPredicateByBoModelQueryParam(boModelParam);
        List<DynamicBoModelDO> doList = new ArrayList<>();
        repository.findAll(predicate).iterator().forEachRemaining(boModelDo -> {
            doList.add(boModelDo);
        });
        return doList;
    }

    @Override
    public DynamicBoModelVo getBoModelVoByCode(String boModelCode) {
        DynamicBoModelDO boModelDo = getBoModelByCode(boModelCode);
        BoFieldQueryParam boFieldQueryParam = new BoFieldQueryParam();
        boFieldQueryParam.setBasicModuleCode(boModelDo.getBoModelCode());
        boFieldQueryParam.setDbTableName(boModelDo.getDatabaseTableName());

        List<DynamicBoFieldDefinitionDO> boFieldDefinitionList =
                boFieldDefinitionService.searchBoFieldList(boFieldQueryParam);
        DynamicBoModelVo boModelVo = new DynamicBoModelVo();
        BeanUtils.copyProperties(boModelDo, boModelVo);
        boModelVo.setDynamicBoFieldDefinitionDoList(boFieldDefinitionList);
        return boModelVo;
    }

    @Override
    public void updateCreateTable(String boModelCode,boolean b) {
        repository.updateCreationTableByBoModelCode( b,boModelCode);
    }

    @Override
    public ApiResult<String> updateBoModelFormJson(BoModelAddViewJsonParam param) {
        repository.findById(param.getBoModelId()).ifPresentOrElse(boDo ->
                {
                    boDo.setFormJson(param.getViewJson());
                    repository.save(boDo);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> updateBoModelListPageJson(BoModelAddViewJsonParam param) {
        repository.findById(param.getBoModelId()).ifPresentOrElse(boDo ->
                {
                    boDo.setListPageJson(param.getViewJson());
                    repository.save(boDo);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok();
    }


}