/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.AddBoModelDbFieldParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelDbService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dynamic/boModel/db"})
@Api(value="\u52a8\u6001\u4e1a\u52a1\u6a21\u578b-\u6570\u636e\u5e93\u8868\u548c\u5b57\u6bb5\u7ba1\u7406", tags={"\u52a8\u6001\u4e1a\u52a1\u6a21\u578b-\u6570\u636e\u5e93\u8868\u548c\u5b57\u6bb5\u7ba1\u7406"})
public class DynamicBoModelDbController {
    private final DynamicBoModelService boModelService;
    private final DynamicBoModelDbService boModelDbService;

    public DynamicBoModelDbController(DynamicBoModelService boModelService, DynamicBoModelDbService boModelDbService) {
        this.boModelService = boModelService;
        this.boModelDbService = boModelDbService;
    }

    @PostMapping(value={"/{boModelCode}/createBoModelDbTable"})
    public ApiResult<String> createBoModelDbTable(@PathVariable String boModelCode) {
        return this.boModelDbService.createBoModelDbTable(boModelCode);
    }

    @PostMapping(value={"/addBoModelDbField"})
    public ApiResult<DynamicBoModelDO> addBoModelDbField(@RequestBody @Valid AddBoModelDbFieldParam param) {
        BoFieldDefinitionSaveParam boFieldParam = param.getBoFieldDefinitionSaveParam();
        DynamicBoFieldDefinitionDO boFieldDefinitionEntity = new DynamicBoFieldDefinitionDO();
        BeanUtils.copyProperties((Object)boFieldParam, (Object)((Object)boFieldDefinitionEntity));
        ApiResult<String> apiResult = this.boModelDbService.addBoModelDbField(param.getBoModelCode(), boFieldDefinitionEntity);
        return apiResult;
    }

    @PostMapping(value={"/{boModelCode}/deleteAndCreatBoModelDbTable"})
    public ApiResult<String> deleteAndCreatBoModelDbTable(@PathVariable String boModelCode) {
        return this.boModelDbService.deleteAndCreatBoModelDbTable(boModelCode);
    }

    @PutMapping(value={"/{boModelCode}/{fieldName}/updateDbField"})
    public ApiResult<String> updateBoModelDbField(@PathVariable String boModelCode, @PathVariable String fieldName, @RequestBody @Valid BoFieldDefinitionUpdateParam boModelDetails) {
        return this.boModelDbService.updateBoModelDbField(boModelCode, fieldName, boModelDetails);
    }

    @DeleteMapping(value={"/{boModelCode}/deleteDbTable"})
    public ApiResult<String> deleteBoModelDbTable(@PathVariable String boModelCode) {
        return this.boModelDbService.deleteBoModelDbTable(boModelCode);
    }

    @DeleteMapping(value={"/{boModelCode}/{fieldName}/deleteDbField"})
    public ApiResult deleteBoModelDbField(@PathVariable String boModelCode, @PathVariable String fieldName) {
        ApiResult<String> apiResult = this.boModelDbService.deleteBoModelDbField(boModelCode, fieldName);
        return apiResult;
    }
}

