/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicWorkflowCfgSimpleBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.query.DynamicConfiguratorPageQueryVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.resp.DynamicConfiguratorPageRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class DynamicConfigurationRepoProc
extends BaseRepoProc<DynamicConfiguratorDO> {
    private static final QDynamicConfiguratorDO QDO = QDynamicConfiguratorDO.dynamicConfiguratorDO;

    public DynamicConfigurationRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeployedApproval(long id, boolean deployed) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.deployedApproval, (Object)deployed).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void deleteApproval(long id) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.createdApproval, (Object)false).set((Path)DynamicConfigurationRepoProc.QDO.deployedApproval, (Object)false).setNull((Path)DynamicConfigurationRepoProc.QDO.approvalEngine).setNull((Path)DynamicConfigurationRepoProc.QDO.approvalKey).setNull(DynamicConfigurationRepoProc.QDO.approvalJson).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeployed(long id, boolean deployed) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.deployed, (Object)deployed).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeployed(String code, boolean deployed) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.deployed, (Object)deployed).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.dynamicConfiguratorCode.eq((Object)code)}).execute();
    }

    public void updatePublished(long id, String appCode, String menuCode) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.published, (Object)true).set((Path)DynamicConfigurationRepoProc.QDO.appCode, (Object)appCode).set((Path)DynamicConfigurationRepoProc.QDO.menuCode, (Object)menuCode).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void revokePublish(long id) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.published, (Object)false).setNull((Path)DynamicConfigurationRepoProc.QDO.appCode).setNull((Path)DynamicConfigurationRepoProc.QDO.menuCode).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateFormCfg(long id, Map<String, Object> formCfg) {
        this.jpaQueryFactory.update((EntityPath)QDO).set(DynamicConfigurationRepoProc.QDO.formJson, formCfg).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateListPageCfg(long id, Map<String, Object> listPageCfg) {
        this.jpaQueryFactory.update((EntityPath)QDO).set(DynamicConfigurationRepoProc.QDO.listPageJson, listPageCfg).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public void updateApprovalCfg(long id, boolean created, String approvalType, String approvalEngine, String approvalKey, Map<String, Object> approvalJson) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)DynamicConfigurationRepoProc.QDO.createdApproval, (Object)created).set((Path)DynamicConfigurationRepoProc.QDO.approvalType, (Object)approvalType).set((Path)DynamicConfigurationRepoProc.QDO.approvalEngine, (Object)approvalEngine).set((Path)DynamicConfigurationRepoProc.QDO.approvalKey, (Object)approvalKey).set(DynamicConfigurationRepoProc.QDO.approvalJson, approvalJson).where(new Predicate[]{DynamicConfigurationRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public boolean existsCode(@NotBlank String code, Long id) {
        return super.exists((Path)DynamicConfigurationRepoProc.QDO.dynamicConfiguratorCode, (Object)code, id);
    }

    public PagingVO<DynamicConfiguratorPageRespVO> pageMng(DynamicConfiguratorPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)DynamicConfigurationRepoProc.QDO.dynamicConfiguratorCode, (Object)queryVO.getDynamicConfiguratorCode()).andLike((StringExpression)DynamicConfigurationRepoProc.QDO.dynamicConfiguratorName, queryVO.getDynamicConfiguratorName()).andEq((SimpleExpression)DynamicConfigurationRepoProc.QDO.approvalType, (Object)queryVO.getApprovalType()).andEq((SimpleExpression)DynamicConfigurationRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).andEq((SimpleExpression)DynamicConfigurationRepoProc.QDO.published, (Object)queryVO.getPublished()).andEq((SimpleExpression)DynamicConfigurationRepoProc.QDO.deployed, (Object)queryVO.getDeployed()).andLike(new StringExpression[]{DynamicConfigurationRepoProc.QDO.dynamicConfiguratorCode, DynamicConfigurationRepoProc.QDO.dynamicConfiguratorName}, queryVO.getKeyword()).build();
        QBean qbean = Projections.bean(DynamicConfiguratorPageRespVO.class, (Expression[])new Expression[]{DynamicConfigurationRepoProc.QDO.id, DynamicConfigurationRepoProc.QDO.dynamicConfiguratorCode, DynamicConfigurationRepoProc.QDO.dynamicConfiguratorName, DynamicConfigurationRepoProc.QDO.dynamicConfiguratorDescription, DynamicConfigurationRepoProc.QDO.enabled, DynamicConfigurationRepoProc.QDO.approvalType, DynamicConfigurationRepoProc.QDO.published, DynamicConfigurationRepoProc.QDO.appCode, DynamicConfigurationRepoProc.QDO.menuCode, DynamicConfigurationRepoProc.QDO.deployed, DynamicConfigurationRepoProc.QDO.createTime, DynamicConfigurationRepoProc.QDO.creator, DynamicConfigurationRepoProc.QDO.modifyTime, DynamicConfigurationRepoProc.QDO.updater});
        return super.queryByPage(qbean, predicate, queryVO.getPageRequest());
    }

    public Boolean isDeployed(long id) {
        return (Boolean)super.getValue((Path)DynamicConfigurationRepoProc.QDO.deployed, id);
    }

    public Boolean isPublished(long id) {
        return (Boolean)super.getValue((Path)DynamicConfigurationRepoProc.QDO.published, id);
    }

    public String getMenuCode(long id) {
        return (String)super.getValue((Path)DynamicConfigurationRepoProc.QDO.menuCode, id);
    }

    public String getCode(long id) {
        return (String)super.getValue((Path)DynamicConfigurationRepoProc.QDO.dynamicConfiguratorCode, id);
    }

    public String getName(long id) {
        return (String)super.getValue((Path)DynamicConfigurationRepoProc.QDO.dynamicConfiguratorName, id);
    }

    public Boolean getDeploy(long id) {
        return (Boolean)super.getValue((Path)DynamicConfigurationRepoProc.QDO.deployed, id);
    }

    public Boolean getPublished(long id) {
        return (Boolean)super.getValue((Path)DynamicConfigurationRepoProc.QDO.published, id);
    }

    public Map<String, Object> getFormJson(long id) {
        return (Map)super.getValue(DynamicConfigurationRepoProc.QDO.formJson, id);
    }

    public Map<String, Object> getListPageJson(long id) {
        return (Map)super.getValue(DynamicConfigurationRepoProc.QDO.listPageJson, id);
    }

    public DynamicWorkflowCfgSimpleBO getWorkflowCfgSimpleBO(long id) {
        QBean qbean = Projections.bean(DynamicWorkflowCfgSimpleBO.class, (Expression[])new Expression[]{DynamicConfigurationRepoProc.QDO.createdApproval, DynamicConfigurationRepoProc.QDO.deployedApproval, DynamicConfigurationRepoProc.QDO.approvalType, DynamicConfigurationRepoProc.QDO.approvalEngine, DynamicConfigurationRepoProc.QDO.approvalKey, DynamicConfigurationRepoProc.QDO.approvalJson});
        return (DynamicWorkflowCfgSimpleBO)super.get(qbean, id);
    }
}

