/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DatabaseTableOperations;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DbDynamicDatabaseServiceImpl
implements DatabaseTableOperations {
    private static final Logger log = LoggerFactory.getLogger(DbDynamicDatabaseServiceImpl.class);
    @Autowired
    DSLContext dslContext;

    @Override
    public void createTable(String tableName, Field<?> ... fields) {
        if (tableName == null || "".equals(tableName)) {
            throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dslContext.createTable(tableName).columns(fields).execute();
    }

    @Override
    public void addField(String tableName, Field<?> field) {
        if (tableName == null || "".equals(tableName)) {
            throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (field == null) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dslContext.alterTable(tableName).addColumn(field).execute();
    }

    @Override
    public void modifyField(String tableName, String fieldName, DataType<?> newDataType) {
        if (tableName == null || "".equals(tableName)) {
            throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dslContext.alterTable(tableName).alterColumn(fieldName).set(newDataType).execute();
    }

    @Override
    public void dropTable(String tableName) {
        if (tableName == null || "".equals(tableName)) {
            throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dslContext.dropTableIfExists(tableName).execute();
    }

    @Override
    public void dropField(String tableName, Field<?> field) {
        if (tableName == null || "".equals(tableName)) {
            throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (field == null) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dslContext.alterTable(tableName).dropColumn(field).execute();
    }
}

