package com.elitescloud.cloudt.lowcode.dynamic.model.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:31
 */
@Data
public class ConfiguratorQueryParam extends AbstractOrderQueryParam implements Serializable {

    @ApiModelProperty("配置能力名称")
    private String dynamicConfiguratorName; // 配置能力名称

    @ApiModelProperty("配置能力编码，唯一标识")
    private String dynamicConfiguratorCode; // 配置能力编码，唯一标识

    @ApiModelProperty("配置能力表类型（单表/主表明细表）")
    private String dynamicConfiguratorType; // 配置能力表类型（单表/主表明细表）

    @ApiModelProperty("前端展示布局模板编码")
    private String layoutTemplateCode; // 前端展示布局模板编码

    @ApiModelProperty("前端展示布局模板名称")
    private String layoutTemplateName; // 前端展示布局模板名称

    @ApiModelProperty("状态")
    private String dynamicConfiguratorStatus; // 状态
}
