package com.elitescloud.cloudt.lowcode.dynamic.model.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 11:47
 */
@Data
public class DbFieldVo {
    private Long id;
    private String dbTableName; //表名
    private String name; // 字段名
    private String type; // 字段类型（如：VARCHAR, INT, DATE等）
    private Integer length; // 字段长度（对于某些类型如VARCHAR是必要的）
    private Integer precision; // 精度，主要用于数值类型，如DECIMAL
    private Integer scale; // 小数位数，与precision搭配使用
    private Boolean nullable; // 字段是否可以为NULL
    private String defaultValue; // 字段的默认值
    private Boolean primaryKey; // 字段是否是主键
    private Boolean unique; // 字段值是否需要唯一
    private Boolean index; // 是否为该字段创建索引
    private String foreignTable; // 外键关联的表名
    private String foreignField; // 外键关联的字段名
    private String checkConstraint; // 字段检查约束表达式
    private String constraints; // 其他约束（如CHECK约束的表达式）
    private String description; // 字段描述
    private Boolean isVirtual; // 是否为虚拟/计算字段
    private String calculationExpression; // 用于虚拟字段的计算表达式
    private Boolean autoIncrement; // 是否自增
    private String collation; // 字符集和排序规则，主要用于字符串类型

    private List<DbFieldRelationVo> dbFieldVos;

}
