package com.elitescloud.cloudt.lowcode.dynamic.model.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 业务模型保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Getter
@Setter
@ApiModel(description = "数据模型保存信息")
public class DynamicBoModelSaveVO implements Serializable {
    private static final long serialVersionUID = -927024780981316569L;

    @ApiModelProperty(value = "数据模型ID，编辑时不可为空")
    private Long boModelId;

    @NotNull(message = "功能模块ID为空")
    @ApiModelProperty(value = "功能模块ID", position = 1, required = true)
    private Long configuratorId;

    @NotBlank(message = "模型编码为空")
    @ApiModelProperty(value = "模型编码", position = 2, required = true)
    private String boModelCode;

    @NotBlank(message = "模型名称为空")
    @ApiModelProperty(value = "模型名称", position = 3, required = true)
    private String boModeName;

    @ApiModelProperty(value = "模型备注", position = 4)
    private String description;

    @NotBlank(message = "关系类型为空")
    @ApiModelProperty(value = "模型关系类型[udc]cloudt-system:modelRelationType", position = 5, required = true)
    private String boModelType;
}
