package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 15:11
 */
@Repository
public interface DbTableRepository extends JpaRepository<DbTableDo, Long> , QuerydslPredicateExecutor<DbTableDo> {
    @Transactional
    @Modifying
    @Query("delete from DbTableDo d where d.tableName = ?1 and d.tableSchema =?2 ")
    int deleteByTableNameAndTableSchema(String tableName, String tableSchema);
    // 可以添加自定义查询方法
}
