package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicDeployModelRecordDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicDeployModelRecordDO;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/25
 */
@Repository
public class DynamicDeployModelRecordRepoProc extends BaseRepoProc<DynamicDeployModelRecordDO> {
    private static final QDynamicDeployModelRecordDO QDO = QDynamicDeployModelRecordDO.dynamicDeployModelRecordDO;
    private static final QDynamicConfiguratorDO QDO_CFG = QDynamicConfiguratorDO.dynamicConfiguratorDO;

    public DynamicDeployModelRecordRepoProc() {
        super(QDO);
    }

    /**
     * 根据功能删除
     *
     * @param configuratorId
     */
    public void deleteByDynamicConfigurator(long configuratorId) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.configuratorCode.eq(
                        JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(configuratorId))
                )).execute();
    }

    public List<DynamicDeployModelRecordDO> listByConfigurator(long configuratorId) {
        var predicate = QDO.configuratorCode.eq(
                JPAExpressions.select(QDO_CFG.dynamicConfiguratorCode).from(QDO_CFG).where(QDO_CFG.id.eq(configuratorId)));
        return super.getList(predicate);
    }
}
