/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.controller;

import cn.hutool.db.meta.Table;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dynamic/db/metadata"})
@Api(value="DB\u5143\u6570\u636e", tags={"DB\u5143\u6570\u636e"})
public class DbMetadaController {
    private final DbTableService dbTableService;
    private final DbDataSourceMetadataService dbDataSourceMetadataService;
    private final DbMetadataService dbMetadataService;

    public DbMetadaController(DbTableService dbTableService, DbDataSourceMetadataService dbDataSourceMetadataService, DbMetadataService dbMetadataService) {
        this.dbMetadataService = dbMetadataService;
        this.dbTableService = dbTableService;
        this.dbDataSourceMetadataService = dbDataSourceMetadataService;
    }

    @PostMapping(value={"/getTableMeta"})
    @ApiOperation(value="\u68c0\u7d22\u8868\u5143\u6570\u636e-\u5f53\u524d\u6570\u636e\u6e90", notes="\u68c0\u7d22\u8868\u5143\u6570\u636e-\u5f53\u524d\u6570\u636e\u6e90")
    public ApiResult<Table> getTableMeta(@RequestBody DbTableParam dbTableParam) {
        Table table = this.dbDataSourceMetadataService.getTableMeta(dbTableParam.getCatalog(), dbTableParam.getSchema(), dbTableParam.getTableName());
        return ApiResult.ok((Object)table);
    }

    @GetMapping(value={"/getCurrentSchema"})
    @ApiOperation(value="\u67e5\u8be2\u9ed8\u8ba4schema-\u5f53\u524d\u6570\u636e\u6e90", notes="\u67e5\u8be2\u9ed8\u8ba4schema-\u5f53\u524d\u6570\u636e\u6e90")
    public ApiResult<String> getCurrentSchema() {
        try {
            String schemaName = this.dbDataSourceMetadataService.getSchema();
            if (schemaName == null || schemaName.isBlank()) {
                schemaName = this.dbMetadataService.getCurrentSchema();
            }
            return ApiResult.ok((Object)schemaName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/getAllSchema"})
    @ApiOperation(value="\u3010\u9700\u6388\u6743mysql\u3011\u67e5\u8be2q\u5168\u90e8schema-\u5f53\u524d\u6570\u636e\u6e90", notes="\u67e5\u8be2\u9ed8\u8ba4schema-\u5f53\u524d\u6570\u636e\u6e90")
    public ApiResult<List<String>> getAllSchema() {
        try {
            return ApiResult.ok(this.dbMetadataService.getAllSchemas());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/getAllTableNames"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u8868\u540d-\u5f53\u524d\u6570\u636e\u6e90\u4e0e\u9ed8\u8ba4schema", notes="\u83b7\u53d6\u5168\u90e8\u8868\u540d-\u5f53\u524d\u6570\u636e\u6e90\u4e0e\u9ed8\u8ba4schema")
    public ApiResult<List<String>> getAllTableNames() {
        return ApiResult.ok(this.dbDataSourceMetadataService.getAllTableNames());
    }

    @PostMapping(value={"/getSchemaTableNames"})
    @ApiOperation(value="\u68c0\u7d22schema\u7684\u5168\u90e8\u8868\u540d-\u5f53\u524d\u6570\u636e\u6e90", notes="\u83b7\u53d6schema\u7684\u5168\u90e8\u8868\u540d-\u5f53\u524d\u6570\u636e\u6e90")
    public ApiResult<List<String>> getSchemaTableNames(@RequestBody DbTableParam dbTableParam) {
        return ApiResult.ok(this.dbDataSourceMetadataService.getSchemaTableNames(dbTableParam.getCatalog(), dbTableParam.getSchema()));
    }

    @PostMapping(value={"/getTableColumnNames"})
    @ApiOperation(value="\u68c0\u7d22\u83b7\u53d6\u8868\u5168\u90e8\u5217\u540d-\u5f53\u524d\u6570\u636e\u6e90\u9ed8\u8ba4schema", notes="\u68c0\u7d22\u83b7\u53d6\u8868\u5168\u90e8\u5217\u540d-\u5f53\u524d\u6570\u636e\u6e90\u9ed8\u8ba4schema")
    public ApiResult<List<String>> getTableColumnNames(@RequestBody DbTableParam dbTableParam) {
        List<String> tableColumn = this.dbDataSourceMetadataService.getAllTableColumnNames(dbTableParam.getCatalog(), dbTableParam.getSchema(), dbTableParam.getTableName());
        return ApiResult.ok(tableColumn);
    }
}

