/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicExportParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportResult;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dynamic/bo/api"})
@Api(value="\u52a8\u6001API-\u4e1a\u52a1\u6a21\u578b", tags={"\u52a8\u6001API-\u4e1a\u52a1\u6a21\u578b"})
public class DynamicApiBoController {
    private static final Logger log = LoggerFactory.getLogger(DynamicApiBoController.class);
    private final DynamicBoApiService dynamicApiService;

    public DynamicApiBoController(DynamicBoApiService dynamicApiService) {
        this.dynamicApiService = dynamicApiService;
    }

    @PostMapping(value={"/{boModelCode}/insert"})
    @ApiOperation(value="\u63d2\u5165{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u63d2\u5165\u6570\u636e}Map<String, Object>", notes="\u63d2\u5165{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public ApiResult<Object> insert(@PathVariable String boModelCode, @RequestBody Map<String, Object> entityData) {
        return this.dynamicApiService.insert(boModelCode, entityData);
    }

    @PostMapping(value={"/{boModelCode}/insertBatch"})
    @ApiOperation(value="\u6279\u91cf\u63d2\u5165{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u63d2\u5165\u6570\u636e} List<Map<String, Object>>", notes="\u6279\u91cf\u63d2\u5165{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801} List<Map<String, Object>>")
    public ApiResult<Object> insertBatch(@PathVariable String boModelCode, @RequestBody List<Map<String, Object>> entityDataList) {
        return this.dynamicApiService.insertBatch(boModelCode, entityDataList);
    }

    @PutMapping(value={"/{boModelCode}/{id}/update"})
    @ApiOperation(value="\u66f4\u65b0{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u67e5\u8be2\u6570\u636eID}{\u66f4\u65b0\u6570\u636e}", notes="\u66f4\u65b0{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public ApiResult<Integer> update(@PathVariable String boModelCode, @PathVariable Long id, @RequestBody Map<String, Object> entityData) {
        return this.dynamicApiService.update(boModelCode, id, entityData);
    }

    @PutMapping(value={"/{boModelCode}/updateBatch"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}\u3010\u66f4\u65b0\u6570\u636eid\uff1a{\u66f4\u65b0\u6570\u636emap}\u3011", notes="\u66f4\u65b0{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public ApiResult<Integer> updateBatch(@PathVariable String boModelCode, @RequestBody Map<Long, Map<String, Object>> entityDataList) {
        return this.dynamicApiService.updateBatch(boModelCode, entityDataList);
    }

    @PostMapping(value={"/{boModelCode}/queryPage/"})
    @ApiOperation(value="\u67e5\u8be2{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u67e5\u8be2\u6761\u4ef6}", notes="\u67e5\u8be2{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public ApiResult<Page<?>> queryPage(@PathVariable String boModelCode, @RequestBody DynamicFieldQueryParam queryParam) {
        return this.dynamicApiService.queryPage(boModelCode, queryParam);
    }

    @GetMapping(value={"/{boModelCode}/{id}/getById"})
    @ApiOperation(value="\u67e5\u8be2{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u67e5\u8be2\u6570\u636eID}", notes="\u67e5\u8be2{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public ApiResult<Map> getById(@PathVariable String boModelCode, @PathVariable Long id) {
        return this.dynamicApiService.getById(boModelCode, id);
    }

    @PostMapping(value={"/{boModelCode}/export"})
    @ApiOperation(value="\u5bfc\u51fa{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}", notes="\u5bfc\u51fa{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public void dynamicExport(@PathVariable String boModelCode, @RequestBody DynamicExportParam dynamicExportParam, HttpServletResponse response) throws IOException {
        this.dynamicApiService.dynamicExport(boModelCode, dynamicExportParam, response);
    }

    @PostMapping(value={"/{boModelCode}/import"})
    @ApiOperation(value="\u5bfc\u5165{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}", notes="\u5bfc\u5165{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}")
    public ApiResult<DynamicImportResult> dynamicImport(@PathVariable String boModelCode, @RequestParam(value="file") MultipartFile file) throws IOException {
        return this.dynamicApiService.dynamicImport(boModelCode, file);
    }

    @DeleteMapping(value={"/{boModelCode}/{id}/delete"})
    @ApiOperation(value="\u5220\u9664{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u5220\u9664\u6570\u636eID}", notes="\u5220\u9664{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u5220\u9664\u6570\u636eID}")
    public ApiResult<?> delete(@PathVariable String boModelCode, @PathVariable Long id) {
        return this.dynamicApiService.delete(boModelCode, id);
    }

    @DeleteMapping(value={"/{boModelCode}/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u5220\u9664\u6570\u636eID}", notes="\u6279\u91cf\u5220\u9664{\u4e1a\u52a1\u6a21\u578b\u7f16\u7801}{\u5220\u9664\u6570\u636eID}")
    public ApiResult<?> deleteBatch(@PathVariable String boModelCode, @RequestBody List<Long> ids) {
        return this.dynamicApiService.deleteBatch(boModelCode, ids);
    }
}

