/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAddViewJsonParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dynamic/boModel"})
@Api(value="\u52a8\u6001\u4e1a\u52a1\u6a21\u578b-\u6a21\u578b\u7ba1\u7406", tags={"\u52a8\u6001\u4e1a\u52a1\u6a21\u578b-\u6a21\u578b\u7ba1\u7406"})
public class DynamicBoModelController {
    @Autowired
    private DynamicBoModelService boModelService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u6a21\u578b", notes="\u521b\u5efa\u6a21\u578b")
    public ApiResult<Long> createBoModel(@RequestBody @Valid BoModelSaveParam boModelParam) {
        return this.boModelService.createBoModel(boModelParam);
    }

    @GetMapping(value={"/code/{boModelCode}"})
    @ApiOperation(value="\u6a21\u578b\u67e5\u8be2", notes="\u6a21\u578b\u67e5\u8be2")
    public ApiResult<DynamicBoModelDO> getBoModelByCode(@PathVariable String boModelCode) {
        DynamicBoModelDO oboModel = this.boModelService.getBoModelByCode(boModelCode);
        return ApiResult.ok((Object)((Object)oboModel));
    }

    @GetMapping(value={"/id/{boModelId}"})
    @ApiOperation(value="\u6a21\u578b\u67e5\u8be2", notes="\u6a21\u578b\u67e5\u8be2")
    public ApiResult<DynamicBoModelDO> getBoModelById(@PathVariable Long boModelId) {
        DynamicBoModelDO oboModel = this.boModelService.getBoModelById(boModelId);
        return ApiResult.ok((Object)((Object)oboModel));
    }

    @PutMapping(value={"/{boModelCode}/update"})
    @ApiOperation(value="\u6a21\u578b\u66f4\u65b0", notes="\u6a21\u578b\u66f4\u65b0")
    public ApiResult<Boolean> updateBoModelByCode(@PathVariable String boModelCode, @RequestBody @Valid BoModelUpdateParam boModelDetails) {
        return this.boModelService.updateBoModel(boModelCode, boModelDetails);
    }

    @PutMapping(value={"/code/{boModeId}/update"})
    @ApiOperation(value="\u6a21\u578b\u66f4\u65b0", notes="\u6a21\u578b\u66f4\u65b0")
    public ApiResult<Boolean> updateBoModelById(@PathVariable Long boModeId, @RequestBody @Valid BoModelUpdateParam boModelDetails) {
        return this.boModelService.updateBoModelById(boModeId, boModelDetails);
    }

    @DeleteMapping(value={"/code/{boModelCode}/delete"})
    public ApiResult<Boolean> deleteBoModel(@PathVariable String boModelCode) {
        this.boModelService.deleteBoModel(boModelCode);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/id/{boModelId}/delete"})
    public ApiResult<Boolean> deleteBoModelById(@PathVariable Long boModelId) {
        this.boModelService.deleteBoModelById(boModelId);
        return ApiResult.ok();
    }

    @PostMapping(value={"/query/page"})
    public ApiResult<PagingVO<DynamicBoModelDO>> queryBoModels(@RequestBody BoModelQueryParam boModelParam) {
        PagingVO<DynamicBoModelDO> pagingVO = this.boModelService.searchBoModels(boModelParam);
        return ApiResult.ok(pagingVO);
    }

    @PostMapping(value={"/query/list"})
    public ApiResult<List<DynamicBoModelDO>> queryBoModelList(@RequestBody BoModelQueryParam boModelParam) {
        List<DynamicBoModelDO> list = this.boModelService.searchBoModelList(boModelParam);
        return ApiResult.ok(list);
    }

    @GetMapping(value={"/getBoModelVoByCode/{boModelCode}"})
    @ApiOperation(value="\u67e5\u8be2\u6a21\u578b\u548c\u6a21\u578b\u5b57\u6bb5", notes="\u67e5\u8be2\u6a21\u578b\u548c\u6a21\u578b\u5b57\u6bb5")
    public ApiResult<DynamicBoModelVo> getBoModelVoByCode(@PathVariable String boModelCode) {
        return ApiResult.ok((Object)((Object)this.boModelService.getBoModelVoByCode(boModelCode)));
    }

    @PostMapping(value={"/addFormJson"})
    @ApiOperation(value="\u6a21\u578b\u6dfb\u52a0\u8868\u5355\u914d\u7f6e", notes="\u6a21\u578b\u6dfb\u52a0\u8868\u5355\u914d\u7f6e")
    public ApiResult<String> addFormJson(@RequestBody @Valid BoModelAddViewJsonParam param) {
        return this.boModelService.updateBoModelFormJson(param);
    }

    @PostMapping(value={"/addListPageJson"})
    @ApiOperation(value="\u6a21\u578b\u6dfb\u52a0\u5217\u8868\u914d\u7f6e", notes="\u6a21\u578b\u6dfb\u52a0\u5217\u8868\u914d\u7f6e")
    public ApiResult<String> addListPageJson(@RequestBody @Valid BoModelAddViewJsonParam param) {
        return this.boModelService.updateBoModelListPageJson(param);
    }
}

