/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.lowcode.dynamic.common.DeployType;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelColumnBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelTableBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.convert.BoModelFieldTypeEnum;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicDeployModelRecordDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicDeployRecordDO;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicConfigurationRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicDeployModelRecordRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.repo.DynamicDeployRecordRepoProc;
import com.google.common.base.Functions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.jooq.AlterTableAddStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableStep;
import org.jooq.Constraint;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.DropTableStep;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SelectSelectStep;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class DynamicBoModelDeployService {
    private static final Logger logger = LoggerFactory.getLogger(DynamicBoModelDeployService.class);
    @Autowired
    private DynamicDeployRecordRepoProc repoProc;
    @Autowired
    private DynamicDeployModelRecordRepoProc modelRecordRepoProc;
    @Autowired
    private DynamicConfigurationRepoProc configurationRepoProc;
    @Autowired
    private TaskExecutor taskExecutor;

    @Transactional(rollbackFor={Exception.class})
    public void deploy(@NotNull DeployType deployType, @NotEmpty List<DynamicModelTableBO> tableBoList, String configuratorCode) {
        Assert.notNull((Object)((Object)deployType), (String)"\u672a\u77e5\u90e8\u7f72\u7c7b\u578b", (Object[])new Object[0]);
        Assert.notEmpty(tableBoList, (String)"\u6570\u636e\u8868\u6a21\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicDeployRecordDO recordDO = new DynamicDeployRecordDO();
        recordDO.setDynamicConfiguratorCode((String)ObjUtil.defaultIfNull((Object)configuratorCode, (Object)""));
        recordDO.setDeployType(deployType.name());
        recordDO.setStartTime(LocalDateTime.now());
        recordDO.setSuccess(false);
        recordDO.setFinished(false);
        this.repoProc.save((Serializable)((Object)recordDO));
        CompletableFuture.runAsync(() -> this.startDeploy(recordDO, deployType, tableBoList), (Executor)this.taskExecutor).whenComplete((r, e) -> {
            String failReason = null;
            if (e != null) {
                failReason = ExceptionsUtil.stackTraceAllToString((Throwable)e);
            }
            try {
                this.repoProc.updateDeployResult(recordDO.getId(), failReason);
                this.configurationRepoProc.updateDeployed(configuratorCode, deployType != DeployType.CANCEL_DEPLOY);
            }
            catch (Exception ex) {
                logger.error("\u66f4\u65b0\u90e8\u7f72\u7ed3\u679c\u5f02\u5e38\uff1a{}, {}", new Object[]{recordDO.getId(), failReason, ex});
            }
        });
    }

    private void startDeploy(DynamicDeployRecordDO recordDO, DeployType deployType, List<DynamicModelTableBO> tableBoList) {
        logger.info("\u5f00\u59cb{}{}...", (Object)deployType.getDescription(), (Object)recordDO.getDynamicConfiguratorCode());
        DataSource datasource = (DataSource)SpringContextHolder.getObjectProvider(DataSource.class).getIfAvailable();
        org.springframework.util.Assert.notNull((Object)datasource, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25");
        DSLContext dslContext = this.buildDsl(datasource);
        String schema = this.getSchemaName(dslContext);
        List<TableExecutor> tableWrappers = this.analyzeTableWrapper(deployType, tableBoList, datasource, schema);
        for (TableExecutor tableWrapper : tableWrappers) {
            tableWrapper.execute(dslContext);
            DynamicDeployModelRecordDO deployModelRecordDO = new DynamicDeployModelRecordDO();
            deployModelRecordDO.setRecordId(recordDO.getId());
            deployModelRecordDO.setBoModelCode(tableWrapper.getBoModelCode());
            deployModelRecordDO.setConfiguratorCode(recordDO.getDynamicConfiguratorCode());
            deployModelRecordDO.setLogJson(tableWrapper.getDescription());
            deployModelRecordDO.setPrettyLogJson(tableWrapper.getDescriptionPretty());
            this.modelRecordRepoProc.save((Serializable)((Object)deployModelRecordDO));
        }
    }

    private List<TableExecutor> analyzeTableWrapper(DeployType deployType, List<DynamicModelTableBO> tableBoList, DataSource dataSource, String schema) {
        List tableNames = MetaUtil.getTables((DataSource)dataSource, (String)schema, (TableType[])new TableType[]{TableType.TABLE});
        ArrayList<TableExecutor> wrappers = new ArrayList<TableExecutor>(tableBoList.size());
        block4: for (DynamicModelTableBO tableBO : tableBoList) {
            if (CharSequenceUtil.isBlank((CharSequence)tableBO.getDatabaseTableName())) {
                throw new BusinessException("\u6570\u636e\u6a21\u578b" + tableBO.getBoModelCode() + "\u914d\u7f6e\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u8868\u540d");
            }
            String tableName = tableBO.getDatabaseTableName();
            switch (deployType) {
                case DEPLOY: 
                case REDEPLOY: {
                    wrappers.add(new TableExecutor(deployType, tableName, tableNames.contains(tableName), tableBO));
                    continue block4;
                }
                case CANCEL_DEPLOY: {
                    Table tableMetadata = MetaUtil.getTableMeta((DataSource)dataSource, null, (String)schema, (String)tableName);
                    wrappers.add(new TableExecutor(deployType, tableName, tableNames.contains(tableName), tableBO, tableMetadata));
                    continue block4;
                }
            }
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u90e8\u7f72\u7c7b\u578b" + String.valueOf((Object)deployType));
        }
        return wrappers;
    }

    private String getSchemaName(DSLContext dslContext) {
        try (SelectSelectStep query = dslContext.select((SelectField)DSL.field((String)"database()", String.class));){
            Record1 result = (Record1)query.fetchOne();
            String string = result == null ? null : (String)result.value1();
            return string;
        }
    }

    private DSLContext buildDsl(DataSource dataSource) {
        SQLDialect dialect = new JooqProperties().determineSqlDialect(dataSource);
        return DSL.using((DataSource)dataSource, (SQLDialect)dialect);
    }

    public static class TableExecutor {
        private final DeployType deployType;
        private final String tableName;
        private final boolean existsTable;
        private final DynamicModelTableBO tableBo;
        private final Table tableMeta;

        public TableExecutor(DeployType deployType, String tableName, boolean existsTable, DynamicModelTableBO tableBo) {
            this.deployType = deployType;
            this.tableName = tableName;
            this.existsTable = existsTable;
            this.tableBo = tableBo;
            this.tableMeta = null;
        }

        public TableExecutor(DeployType deployType, String tableName, boolean existsTable, DynamicModelTableBO tableBo, Table tableMeta) {
            this.deployType = deployType;
            this.tableName = tableName;
            this.existsTable = existsTable;
            this.tableBo = tableBo;
            this.tableMeta = tableMeta;
        }

        public String getBoModelCode() {
            return this.tableBo.getBoModelCode();
        }

        public String getDescription() {
            switch (this.deployType) {
                case DEPLOY: {
                    return "\u90e8\u7f72\u8868" + this.tableName;
                }
                case REDEPLOY: {
                    return "\u91cd\u65b0\u90e8\u7f72\u8868" + this.tableName;
                }
                case CANCEL_DEPLOY: {
                    return "\u53d6\u6d88\u90e8\u7f72\u8868" + this.tableName;
                }
            }
            return "\u672a\u77e5\u64cd\u4f5c";
        }

        public String getDescriptionPretty() {
            switch (this.deployType) {
                case DEPLOY: {
                    if (this.existsTable) {
                        return "\u66f4\u65b0\u8868\uff1a" + this.tableName;
                    }
                    return "\u65b0\u589e\u8868\uff1a" + this.tableName;
                }
                case REDEPLOY: {
                    return "\u5220\u9664\u5e76\u65b0\u589e\u8868" + this.tableName;
                }
                case CANCEL_DEPLOY: {
                    return "\u5220\u9664\u8868\uff1a" + this.tableName;
                }
            }
            return "\u672a\u77e5\u64cd\u4f5c";
        }

        public void execute(DSLContext dslContext) {
            switch (this.deployType) {
                case DEPLOY: {
                    if (this.existsTable) {
                        this.executeUpdateTable(dslContext);
                        break;
                    }
                    this.executeCreateTable(dslContext);
                    break;
                }
                case REDEPLOY: {
                    this.executeDeleteTable(dslContext);
                    this.executeCreateTable(dslContext);
                    break;
                }
                case CANCEL_DEPLOY: {
                    this.executeDeleteTable(dslContext);
                }
            }
        }

        private void executeUpdateTable(DSLContext dslContext) {
            AlterTableStep alter = dslContext.alterTable(this.tableName);
            Map columnMap = this.tableMeta == null || this.tableMeta.getColumns() == null ? Collections.emptyMap() : this.tableMeta.getColumns().stream().collect(Collectors.toMap(Column::getName, Functions.identity(), (t1, t2) -> t1));
            for (DynamicModelColumnBO columnBO : this.tableBo.getColumnList()) {
                if (columnMap.containsKey(columnBO.getBasicKey())) {
                    AlterTableFinalStep step;
                    Column column = (Column)columnMap.get(columnBO.getBasicKey());
                    if (!CharSequenceUtil.equals((CharSequence)column.getColumnDef(), (CharSequence)columnBO.getBasicDefaultValue())) {
                        if (StringUtils.hasText((String)columnBO.getBasicDefaultValue())) {
                            step = alter.alterColumn(columnBO.getBasicKey()).setDefault(this.normalizeDefaultValue(columnBO.getBasicType(), columnBO.getBasicDefaultValue()));
                            try {
                                step.execute();
                            }
                            finally {
                                if (step != null) {
                                    step.close();
                                }
                            }
                        }
                        step = alter.alterColumn(columnBO.getBasicKey()).dropDefault();
                        try {
                            step.execute();
                        }
                        finally {
                            if (step != null) {
                                step.close();
                            }
                        }
                    }
                    if (column.isNullable() && Boolean.FALSE.equals(columnBO.getDbFieldNullable())) {
                        step = alter.alterColumn(columnBO.getBasicKey()).setNotNull();
                        try {
                            step.execute();
                            continue;
                        }
                        finally {
                            if (step != null) {
                                step.close();
                            }
                            continue;
                        }
                    }
                    if (column.isNullable() || !Boolean.TRUE.equals(columnBO.getDbFieldNullable())) continue;
                    step = alter.alterColumn(columnBO.getBasicKey()).dropNotNull();
                    try {
                        step.execute();
                        continue;
                    }
                    finally {
                        if (step == null) continue;
                        step.close();
                        continue;
                    }
                }
                AlterTableAddStep step = alter.addColumn(columnBO.getBasicKey(), this.buildDataType(columnBO));
                try {
                    step.execute();
                }
                finally {
                    if (step == null) continue;
                    step.close();
                }
            }
        }

        private void executeCreateTable(DSLContext dslContext) {
            try (CreateTableColumnStep step = dslContext.createTable(this.tableName);){
                ArrayList<String> keyColumns = new ArrayList<String>(8);
                for (DynamicModelColumnBO columnBO : this.tableBo.getColumnList()) {
                    step.column(columnBO.getBasicKey(), this.buildDataType(columnBO));
                    if (!Boolean.TRUE.equals(columnBO.getPrimaryKey())) continue;
                    keyColumns.add(columnBO.getBasicKey());
                }
                if (!keyColumns.isEmpty()) {
                    step.constraint((Constraint)DSL.constraint((String)("pk_" + this.tableName)).primaryKey(keyColumns.toArray(new String[0])));
                }
                step.execute();
            }
        }

        private void executeDeleteTable(DSLContext dslContext) {
            if (!this.existsTable) {
                return;
            }
            try (DropTableStep query = dslContext.dropTable(this.tableName);){
                query.execute();
            }
        }

        private String buildComment(DynamicModelColumnBO columnBO) {
            String description = columnBO.getBasicName();
            if (CharSequenceUtil.isBlank((CharSequence)columnBO.getBasicDescription())) {
                return description;
            }
            return StringUtils.hasText((String)description) ? description + "," + columnBO.getBasicDescription() : columnBO.getBasicDescription();
        }

        private DataType<?> buildDataType(DynamicModelColumnBO columnBO) {
            DataType dataType = null;
            Object defaultValue = this.normalizeDefaultValue(columnBO.getBasicType(), columnBO.getBasicDefaultValue());
            switch (columnBO.getBasicType()) {
                case STRING: {
                    dataType = SQLDataType.VARCHAR((int)((Integer)ObjUtil.defaultIfNull((Object)columnBO.getDbFieldLength(), (Object)255)));
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((String)defaultValue));
                    break;
                }
                case BOOLEAN: {
                    dataType = SQLDataType.BOOLEAN;
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((Boolean)defaultValue));
                    break;
                }
                case EMAIL: {
                    dataType = SQLDataType.VARCHAR((int)((Integer)ObjUtil.defaultIfNull((Object)columnBO.getDbFieldLength(), (Object)255)));
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((String)defaultValue));
                    break;
                }
                case MONEY: {
                    dataType = SQLDataType.DECIMAL((int)((Integer)ObjUtil.defaultIfNull((Object)columnBO.getDbFieldPrecision(), (Object)18)), (int)((Integer)ObjUtil.defaultIfNull((Object)columnBO.getDbFieldScale(), (Object)6)));
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((BigDecimal)defaultValue));
                    break;
                }
                case LONG: {
                    dataType = SQLDataType.BIGINT;
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((Long)defaultValue));
                    break;
                }
                case DOUBLE: {
                    dataType = SQLDataType.DOUBLE;
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((Double)defaultValue));
                    break;
                }
                case INTEGER: {
                    dataType = SQLDataType.INTEGER;
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((Integer)defaultValue));
                    break;
                }
                case DATE: {
                    dataType = SQLDataType.LOCALDATE;
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((LocalDate)defaultValue));
                    break;
                }
                case DATE_TIME: {
                    dataType = SQLDataType.LOCALDATETIME;
                    if (defaultValue == null) break;
                    dataType.defaultValue((Object)((LocalDateTime)defaultValue));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported field type: " + String.valueOf(this));
                }
            }
            return dataType.nullable(columnBO.getDbFieldNullable() == null || Boolean.TRUE.equals(columnBO.getDbFieldNullable()));
        }

        private <T> T normalizeDefaultValue(BoModelFieldTypeEnum fieldTypeEnum, String defaultValue) {
            if (!StringUtils.hasText((String)defaultValue)) {
                return null;
            }
            switch (fieldTypeEnum) {
                case STRING: {
                    return (T)defaultValue;
                }
                case BOOLEAN: {
                    return (T)Boolean.valueOf(defaultValue);
                }
                case EMAIL: {
                    return (T)defaultValue;
                }
                case MONEY: {
                    return (T)new BigDecimal(defaultValue);
                }
                case LONG: {
                    return (T)Long.valueOf(defaultValue);
                }
                case DOUBLE: {
                    return (T)Double.valueOf(defaultValue);
                }
                case INTEGER: {
                    return (T)Integer.valueOf(defaultValue);
                }
                case DATE: {
                    return (T)DatetimeUtil.parseLocalDate((String)defaultValue);
                }
                case DATE_TIME: {
                    return (T)DatetimeUtil.parseLocalDateTime((String)defaultValue);
                }
            }
            throw new IllegalStateException("Unsupported field type: " + String.valueOf(this));
        }
    }
}

