package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.AddBoModelDbFieldParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelDbService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 10:23
 */
@RestController
@RequestMapping("/dynamic/boModel/db")
@Api(value = "动态业务模型-数据库表和字段管理", tags = {"动态业务模型-数据库表和字段管理"})
public class DynamicBoModelDbController {


    private final DynamicBoModelService boModelService;

    private final DynamicBoModelDbService boModelDbService;

    public DynamicBoModelDbController(DynamicBoModelService boModelService, DynamicBoModelDbService boModelDbService) {
        this.boModelService = boModelService;
        this.boModelDbService = boModelDbService;
    }

    @PostMapping("/{boModelCode}/createBoModelDbTable")
    public ApiResult<String> createBoModelDbTable(@PathVariable String boModelCode) {
        return boModelDbService.createBoModelDbTable(boModelCode);
    }

    @PostMapping("/addBoModelDbField")
    public ApiResult<DynamicBoModelDO> addBoModelDbField(@RequestBody @Valid AddBoModelDbFieldParam param) {
        var boFieldParam = param.getBoFieldDefinitionSaveParam();
        DynamicBoFieldDefinitionDO boFieldDefinitionEntity = new DynamicBoFieldDefinitionDO();
        BeanUtils.copyProperties(boFieldParam, boFieldDefinitionEntity);
        ApiResult apiResult = boModelDbService.addBoModelDbField(param.getBoModelCode(), boFieldDefinitionEntity);
        return apiResult;
    }
    @PostMapping("/{boModelCode}/deleteAndCreatBoModelDbTable")
    public ApiResult<String> deleteAndCreatBoModelDbTable(@PathVariable String boModelCode) {
        return boModelDbService.deleteAndCreatBoModelDbTable(boModelCode);
    }
    @PutMapping("/{boModelCode}/{fieldName}/updateDbField")
    public ApiResult<String> updateBoModelDbField(@PathVariable String boModelCode,
                                                  @PathVariable String fieldName,
                                                  @RequestBody @Valid BoFieldDefinitionUpdateParam boModelDetails) {
        return boModelDbService.updateBoModelDbField(boModelCode, fieldName, boModelDetails);
    }

    @DeleteMapping("/{boModelCode}/deleteDbTable")
    public ApiResult<String> deleteBoModelDbTable(@PathVariable String boModelCode) {
        return boModelDbService.deleteBoModelDbTable(boModelCode);
    }

    @DeleteMapping("/{boModelCode}/{fieldName}/deleteDbField")
    public ApiResult deleteBoModelDbField(@PathVariable String boModelCode,
                                          @PathVariable String fieldName) {
        var apiResult = boModelDbService.deleteBoModelDbField(boModelCode, fieldName);
        return apiResult;
    }


}