package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbTableVo;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jooq.DSLContext;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-25 19:54
 */
@RestController
@RequestMapping("/dynamic/db/model")
@Api(value = "DB元数据模型", tags = {"DB元数据模型"})
public class DynamicDbModelController {

    //    private ApplicationContext applicationContext;
    private final DSLContext dsl;
    private final DbTableService dbTableService;

    private final  DbDataSourceMetadataService dbDataSourceMetadataService;

    public DynamicDbModelController(DSLContext dsl, DbTableService dbTableService,DbDataSourceMetadataService dbDataSourceMetadataService) {
        this.dsl = dsl;
        this.dbTableService = dbTableService;
        this.dbDataSourceMetadataService = dbDataSourceMetadataService;
    }

    @PostMapping("/{tableName}/findByTableName")
    @ApiOperation(value = "查询存储的表名的表元数据", notes = "查询存储的表名的表元数据")
    public ApiResult<DbTableVo> findByTableName(@PathVariable String tableName) {
        var vo = dbTableService.findByTableName(tableName);
        return ApiResult.ok(vo);
    }

    @PostMapping("/findAll")
    @ApiOperation(value = "查询存储的表元数据", notes = "查询存储的表元数据")
    public ApiResult<List<DbTableDo>> findAll() {
        var vo = dbTableService.findAll();
        return ApiResult.ok(vo);
    }


    @PostMapping("/storeTablesAndFieldsMetadata")
    @ApiOperation(value = "采集指定表和字段元数据-清空数据采集", notes = "采集指定表和字段元数据-清空数据采集")
    public ApiResult<String> storeTablesAndFieldsMetadata(@RequestBody DbTableParam dbTableParam) {
        return  dbTableService.storeTablesAndFieldsMetadata(dbTableParam);
    }

}
