/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class DbDataMetaUtil
extends MetaUtil {
    public static String[] getColumnNamesByCatalog(DataSource ds, String catalog, String schema, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(catalog, schema, tableName, null);){
                if (null != rs) {
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            stringArray = columnNames.toArray(new String[0]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        return stringArray;
    }

    public static List<String> getTablesByCatalog(DataSource ds, String catalog, String schema, TableType ... types) {
        ArrayList<String> tables = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (null == schema) {
                schema = DbDataMetaUtil.getSchema((Connection)conn);
            }
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, null, Convert.toStrArray((Object)types));){
                if (null != rs) {
                    while (rs.next()) {
                        String table = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                        tables.add(table);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        return tables;
    }
}

