package com.elitescloud.cloudt.lowcode.dynamic.model.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;

/**
 * 功能模块保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Getter
@Setter
@ApiModel(description = "功能模块保存信息")
public class DynamicConfiguratorSaveVO implements Serializable {
    private static final long serialVersionUID = 8857040528116582328L;

    @ApiModelProperty(value = "ID，修改时不可为空", position = 1)
    private Long id;

    @ApiModelProperty(value = "功能模块编码", position = 2, required = true)
    @NotBlank(message = "功能模块编码为空")
    private String dynamicConfiguratorCode;

    @ApiModelProperty(value = "功能模块名称", position = 3, required = true)
    @NotBlank(message = "功能模块名称为空")
    private String dynamicConfiguratorName;

    @ApiModelProperty(value = "流程审批类型，UDC[cloudt-system:approveType]", position = 4)
    private String approvalType;

    @ApiModelProperty(value = "操作功能", position = 5)
    private Map<String, Object> operateJson;

    @ApiModelProperty(value = "描述", position = 11)
    private String dynamicConfiguratorDescription;
}
