package com.elitescloud.cloudt.lowcode.dynamic.service.db.impl;

import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.data.support.audit.CustomAuditUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.core.provider.IdGenerator;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbAuditFields;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbAuditFieldService;
import lombok.extern.slf4j.Slf4j;
import org.jooq.DataType;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 10:07
 */
@Slf4j
@Service
public class DbAuditFieldServiceImpl implements DbAuditFieldService {
   private final TenantClientProvider tenantClientProvider;

    public DbAuditFieldServiceImpl(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public void fillInsertAuditFields(Map<String, Object> entityData) {
        DbAuditFields dbAuditFields=new DbAuditFields();
        dbAuditFields= CustomAuditUtil.markCreated(dbAuditFields);
        Long aLong = IdGenerator.generateLong();
        dbAuditFields.setId(aLong);
        if (dbAuditFields != null) {
            setFieldsToMap(entityData, dbAuditFields);
        }
    }

    @Override
    public void fillUpdateAuditFields(Map<String, Object> entityData) {
        DbAuditFields dbAuditFields=new DbAuditFields();
        dbAuditFields= CustomAuditUtil.markModified(dbAuditFields);
        if (dbAuditFields != null) {
            setFieldsToMap(entityData, dbAuditFields);
        }
    }
    @Override
    public Long getCurrentUserId() {
        // 获取当前用户ID的逻辑
        return   SecurityContextUtil.currentUser().getUserId();
    }
    @Override
    public Long getCurrentTenantId() {
       var tenant = tenantClientProvider.getCurrentTenant();
        if(tenant==null){
            return -1L;
        }
        // 获取当前租户ID的逻辑
        return tenantClientProvider.getCurrentTenant().getId();
    }
    @Override
    public List<org.jooq.Field> getAuditFields() {
        org.jooq.Field[] fields = new org.jooq.Field[] {
                DSL.field(DSL.name("id"), SQLDataType.BIGINT),
                DSL.field(DSL.name("tenant_id"), SQLDataType.BIGINT),
                DSL.field(DSL.name("belong_org_id"),SQLDataType.BIGINT),
                DSL.field(DSL.name("tenant_org_id"),SQLDataType.BIGINT),
                DSL.field(DSL.name("remark"), SQLDataType.VARCHAR(2000)),
                DSL.field(DSL.name("create_user_id"), SQLDataType.BIGINT),
                DSL.field(DSL.name("creator"), SQLDataType.VARCHAR(200)),
                DSL.field(DSL.name("create_time"), SQLDataType.LOCALDATETIME),
                DSL.field(DSL.name("modify_user_id"),SQLDataType.BIGINT),
                DSL.field(DSL.name("updater"), SQLDataType.VARCHAR(200)),
                DSL.field(DSL.name("modify_time"),SQLDataType.LOCALDATETIME),
                DSL.field(DSL.name("delete_flag"), SQLDataType.INTEGER),
                DSL.field(DSL.name("audit_data_version"),SQLDataType.INTEGER),
                DSL.field(DSL.name("sec_bu_id"), SQLDataType.BIGINT),
                DSL.field(DSL.name("sec_user_id"),SQLDataType.BIGINT),
                DSL.field(DSL.name("sec_ou_id"),SQLDataType.BIGINT)
        };
        return Arrays.asList(fields);
    }
    private static void setFieldsToMap(Map<String, Object> entityData, DbAuditFields dbAuditFields) {

        // 获取对象的所有字段
        Field[] fields = ReflectUtil.getFields(dbAuditFields.getClass());
        for (Field field : fields) {
            if(isExcludedField(field)){
                continue;
            }
            field.setAccessible(true); // 设置字段可访问
            try {
                Object value = field.get(dbAuditFields); // 获取字段的值
                if (value != null) {
                    // 将字段名和值设置到 entityData 中
                    entityData.put(camelCaseToUnderscore(field.getName()), value);
                }
            } catch (IllegalAccessException e) {
                log.error("获取字段值失败", e);
            }
        }
    }
    private static boolean isExcludedField(Field field) {
        // 检查字段名是否为 serialVersionUID，如果是，则排除
        return field.getName().equals("serialVersionUID");
    }

    private static String camelCaseToUnderscore(String camelCaseString) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCaseString.length(); i++) {
            char currentChar = camelCaseString.charAt(i);
            // 如果当前字符是大写字母且不是第一个字符，则在前面加上下划线
            if (Character.isUpperCase(currentChar) && i != 0) {
                result.append("_");
            }
            // 将当前字符转换为小写，并添加到结果字符串中
            result.append(Character.toLowerCase(currentChar));
        }
        return result.toString();
    }


}
