package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;


import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DatabaseTableOperations;
import lombok.extern.slf4j.Slf4j;
import org.jooq.*;
import org.jooq.impl.SQLDataType;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Service;


/**
 * @author : chen.niu
 * @description : 数据库维护
 * @date : 2024-04-02 19:36
 */
@Service
@Slf4j
public class DbDynamicDatabaseServiceImpl implements DatabaseTableOperations {

    @Autowired
    org.jooq.DSLContext dslContext;


    // 创建表的方法
    @Override
    public void createTable(String tableName, org.jooq.Field<?>... fields) {
        if(tableName==null||"".equals(tableName)){
            throw new IllegalArgumentException("表名不能为空");
        }
        if(fields==null||fields.length==0){
            throw new IllegalArgumentException("字段不能为空");
        }
        dslContext.createTable(tableName)
                .columns(fields)
                .execute();
    }

    // 添加字段的方法
    @Override
    public void addField(String tableName, org.jooq.Field<?> field) {

        if(tableName==null||"".equals(tableName)){
            throw new IllegalArgumentException("表名不能为空");
        }
        if(field==null){
            throw new IllegalArgumentException("字段不能为空");
        }

        dslContext.alterTable(tableName)
                .addColumn(field)
                .execute();
    }

    // 修改字段的方法
    @Override
    public void modifyField(String tableName, String fieldName, DataType<?> newDataType) {
        if(tableName==null||"".equals(tableName)){
            throw new IllegalArgumentException("表名不能为空");
        }
        dslContext.alterTable(tableName)
                .alterColumn(fieldName).set(newDataType)
                .execute();
    }

    // 删除表的方法
    @Override
    public void dropTable(String tableName) {
        if(tableName==null||"".equals(tableName)){
            throw new IllegalArgumentException("表名不能为空");
        }
        dslContext.dropTableIfExists(tableName)
                .execute();
    }

    // 删除字段的方法
    @Override
    public void dropField(String tableName, org.jooq.Field<?> field) {
        if(tableName==null||"".equals(tableName)){
            throw new IllegalArgumentException("表名不能为空");
        }
        if(field==null){
            throw new IllegalArgumentException("字段不能为空");
        }
        dslContext.alterTable(tableName)
                .dropColumn(field)
                .execute();
    }

}
