package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicConfiguratorDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.ConfiguratorUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicConfiguratorService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-07 11:40
 */
@RestController
@RequestMapping("/dynamic/configurators")
@Api(value = "配置能力-配置管理", tags = {"配置能力-配置管理"})
public class DynamicConfiguratorController {

    @Autowired
    private DynamicConfiguratorService configuratorService;

    @PostMapping
    @GetMapping("/createConfigurator")
    public ApiResult<Long> createConfigurator(@RequestBody ConfiguratorSaveParam configuratorParam) {
        return configuratorService.createConfigurator(configuratorParam);
    }


    @GetMapping("/getConfiguratorById/{id}")
    public ApiResult<DynamicConfiguratorDO> getConfiguratorById(@PathVariable Long id) {
        var configurator =configuratorService.getConfiguratorById(id);
        return ApiResult.ok(configurator);
    }
    @GetMapping("/getConfiguratorByCode/{code}")
    public ApiResult<DynamicConfiguratorDO> getConfiguratorByCode(@PathVariable String code) {
        var configurator =configuratorService.getConfiguratorByCode(code);
        return ApiResult.ok(configurator);
    }

    @PutMapping("/updateConfigurator/{id}")
    public ApiResult<Boolean> updateConfigurator(@PathVariable Long id,
                                                 @RequestBody ConfiguratorUpdateParam configuratorDetails) {
        return configuratorService.updateConfigurator(id, configuratorDetails);
    }

    @DeleteMapping("/deleteConfigurator/{id}")
    public ApiResult<Boolean> deleteConfigurator(@PathVariable Long id) {
        configuratorService.deleteConfigurator(id);
        return ApiResult.ok(true);
    }

    @PostMapping("/query/page")
    public ApiResult<PagingVO<DynamicConfiguratorDO>> queryConfigurators(@RequestBody ConfiguratorQueryParam configuratorParam) {
        return configuratorService.searchConfigurators(configuratorParam);
    }

    @PostMapping("/query/list")
    public ApiResult<List<DynamicConfiguratorDO>> queryConfiguratorList(@RequestBody ConfiguratorQueryParam configuratorParam) {
        return configuratorService.searchConfiguratorList(configuratorParam);
    }
}